%define _cgibin /var/www/cgi-bin
%def_disable cgi

Name: apcupsd
Version: 3.14.14
Release: alt1
Packager: Sergey Y. Afonin <asy@altlinux.ru>

Summary: Power management software for APC UPS hardware
License: %gpl2only
Group: System/Servers
Url: http://www.apcupsd.org/

Source: ftp://ftp.apcupsd.com/pub/%name/development/%name-%version.tar.gz
Source1: apcupsd-platforms-altlinux.tgz
Source2: apcupsd-makesymlinks
Source3: apcupsd-upsdmessages
Source4: apcupsdmessages
Source5: apcupsd-get_killpower_delay
Source6: apcupsd-README.ALT.utf8

Patch1: %name-3.14.6-alt-specific-configure.in.patch
Patch2: %name-3.12.2-config.sub.patch
Patch3: %name-3.14.8-apctest.date.patch

Patch10: apcupsd-3.14.4-hal_policy-Makefile.patch

#Errata/FR
#Patch100:

BuildRequires: rpm-build-licenses

BuildRequires: gcc-c++ imake makedepend gzip-utils hostinfo libncurses-devel libtinfo-devel libX11-devel libusb-compat-devel

%description -n %name
UPS power management under Linux for APCC Products. It allows your
computer/server to run during power problems for a specified length
of time or the life of the batteries in your BackUPS, BackUPS Pro,
SmartUPS v/s, or SmartUPS, and then properly executes a controlled
shutdown during an extended power failure. The "apctest" can change
EEPROM values on some UPS models (via rs-232 cable).

!!Warning!! UPSes with Microlink protocol is not supported
because APC does not reveal features of the protocol.

%package doc
Group: System/Servers
License: %fdl
Summary: apcupsd documentation
BuildArch: noarch

%description doc
The %name-doc package contains Here the documentation about
apcupsd daemon and apctest utility.

#package locales
#Summary: National Language files for apcupsd
#License: %gpl2only
#Group: System/Servers
#BuildArch: noarch
#
#description locales
#National Language files for apcupsd

%package cgi
Summary: Web status for UPS
License: %gpl2only
Group: Networking/Other
Requires: %name = %version-%release, apache-common

%description cgi
Web status for UPS.

%prep
%setup -q

%patch1 -p0
#patch2 -p1
%patch3 -p2

%patch10 -p0

#patch100 -p0

tar xzf %{SOURCE1}

%build

export ac_cv_path_MAIL=/bin/mail
export ac_cv_path_ETAGS=/usr/bin/ctags
export ac_cv_path_CTAGS=/usr/bin/ctags
%add_optflags -DCSS_DIR="\"\\\"./\\\"\""
autoconf -I autoconf autoconf/configure.in > configure
#autoheader -I autoconf autoconf/configure.in > autoconf/config.h.in

#autoreconf

# work around for autoconf_2.60
export ac_cv_path_SHUTDOWN=/sbin/shutdown

%configure \
	--sbindir=/sbin \
	--sysconfdir=%_sysconfdir/%name \
	--with-log-dir=%_localstatedir/%name \
	--with-lock-dir=%_lockdir/serial \
	%{subst_enable cgi} \
	--enable-usb \
	--enable-modbus-usb \
	--enable-net \
	--enable-snmp \
	--with-cgi-bin=%_cgibin \
	--with-nisip=127.0.0.1 \
	--with-distname=altlinux

# SMP-incompatible build.
make

%install
mkdir -p $RPM_BUILD_ROOT{%_sbindir,%_initdir,%_cgibin,%_localstatedir/%name}

%makeinstall \
	sysconfdir=$RPM_BUILD_ROOT%_sysconfdir/%name \
	sbindir=$RPM_BUILD_ROOT/sbin \
	mandir=$RPM_BUILD_ROOT%_mandir \
	cgibin=$RPM_BUILD_ROOT%_cgibin \
	CSS_DIR=$RPM_BUILD_ROOT%_cgibin \
	#

pushd $RPM_BUILD_ROOT/sbin
	for f in apc*; do
		ln -s ../../sbin/"$f" ..%_sbindir/
	done
popd

cp %{SOURCE5} $RPM_BUILD_ROOT/%_sysconfdir/%name/get_killpower_delay
cp %{SOURCE3} $RPM_BUILD_ROOT/%_sysconfdir/%name/upsdmessages
mkdir $RPM_BUILD_ROOT/%_sysconfdir/sysconfig
cp %{SOURCE4} $RPM_BUILD_ROOT/%_sysconfdir/sysconfig/apcupsdmessages

# build new action's script
pushd $RPM_BUILD_ROOT/%_sysconfdir/%name
	sh %{SOURCE2}
popd

cp %{SOURCE6} README.ALT.utf8

cp $RPM_BUILD_DIR/%name-%version/src/apctest $RPM_BUILD_ROOT/%_sbindir/

touch $RPM_BUILD_ROOT%_sysconfdir/{nologin,%name/powerfail}

gzip ChangeLog

#find_lang %name

%post
%post_service %name

%preun
%preun_service %name

%files
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*
%config(noreplace) %_sysconfdir/sysconfig/apcupsdmessages
%attr(0755,root,root) %config(noreplace) %_initdir/%name
%attr(0755,root,root) /sbin/*
%attr(0755,root,root) %_sbindir/*
%_localstatedir/%name
%_mandir/man?/*
%ghost %_sysconfdir/%name/powerfail
%ghost %_sysconfdir/nologin
%doc ChangeLog.gz Developers ReleaseNotes README.ALT.utf8
%exclude %_datadir/hal/fdi/policy/20thirdparty/80-apcupsd-ups-policy.fdi

#files locales -f %name.lang

%files doc
%doc INSTALL doc examples

%if_enabled cgi
%files cgi
%_cgibin/*
%endif

%changelog
