%define _unpackaged_files_terminate_build 1
%def_without docs

Name:    appstream
Version: 0.16.4
Release: alt1

Summary: Utilities to generate, maintain and access the AppStream Xapian database
# library; LGPLv2+, tools: GPLv2+
License: GPL-2.0+ and LGPL-2.0+
Group:   System/Configuration/Packaging

Url:     http://www.freedesktop.org/wiki/Distributions/AppStream/
# VCS:   https://github.com/ximion/appstream
Source:  appstream-%version.tar
Patch:   appstream-0.15.5-meson-build.patch

BuildRequires(pre): meson
BuildRequires: gcc-c++
BuildRequires: ctest
BuildRequires: gettext
BuildRequires: gobject-introspection-devel
BuildRequires: gperf
BuildRequires: intltool
BuildRequires: itstool
BuildRequires: libcurl-devel
BuildRequires: liblmdb-devel
BuildRequires: libprotobuf-lite-devel
BuildRequires: libstemmer-devel
BuildRequires: libxapian-devel
BuildRequires: libxml2-devel
BuildRequires: libyaml-devel
BuildRequires: ninja-build
BuildRequires: protobuf-compiler
%if_with docs
BuildRequires: daps
%endif
BuildRequires: qt5-base-devel
BuildRequires: xmlto
BuildRequires: gtk-doc
BuildRequires: libsoup-devel
BuildRequires: /proc
BuildRequires: libxmlb-devel
BuildRequires: qt5-tools
BuildRequires: libsystemd-devel

#Requires: appstream-data

%description
AppStream-Core makes it easy to access application information from the
AppStream database over a nice GObject-based interface.

%package -n libappstream
Summary: Library to access AppStream services
Group: System/Libraries

%description -n libappstream
%summary.

%package -n libappstream-devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Provides: %name-devel = %EVR
Obsoletes: %name-devel < %EVR

%description -n libappstream-devel
%summary.

%package -n libappstream-qt
Summary: Qt bindings for %name
Group: System/Libraries
Requires: %name = %version-%release
Provides: %name-qt = %EVR
Obsoletes: %name-qt < %EVR

%description -n libappstream-qt
%summary.

%package -n libappstream-qt-devel
Summary: Development files for %name-qt bindings
Group: Development/KDE and QT
Requires: %name-qt = %version-%release
Provides: %name-qt-devel = %EVR
Obsoletes: %name-qt-devel < %EVR

%description -n libappstream-qt-devel
%summary.

%package doc
Summary: Documenation for development using %name
Group: Development/Documentation
BuildArch: noarch

%description doc
%summary.

%prep
%setup
%patch -p1
%ifarch %e2k
# workaround for EDG frontend
sed -i "s|g_autofree gchar \*\*|g_autofree_edg(gchar*)|" qt/pool.cpp
sed -i "s|g_autofree gchar \*|g_autofree_edg(gchar)|" qt/spdx.cpp
sed -i "s/-Werror=shadow/-Wno-error=shadow/" meson.build
%endif

%build
%meson  -Dqt=true \
%if_with docs
	-Ddocs=true \
%else
	-Ddocs=false \
%endif
	-Dstemming=true
%ifarch %e2k
export LD_LIBRARY_PATH=$(pwd)/%__builddir/src
%endif
%meson_build

%install
%meson_install
mkdir -p %buildroot%_datadir/app-info/{icons,xmls}
mkdir -p %buildroot/var/cache/app-info/{icons,xapian,xmls}
touch %buildroot/var/cache/app-info/cache.watch
rm -f %buildroot%_datadir/installed-tests/appstream/metainfo-validate.test

%find_lang %name

%check
#%%meson_test

%files -f appstream.lang
%doc AUTHORS MAINTAINERS NEWS README.md RELEASE
%config(noreplace) %_sysconfdir/appstream.conf
%_bindir/appstreamcli
%dir %_datadir/app-info/
%dir %_datadir/app-info/icons
%dir %_datadir/app-info/xmls
%ghost %_cachedir/app-info/cache.watch
%dir %_cachedir/app-info
%dir %_cachedir/app-info/icons
%dir %_cachedir/app-info/xapian
%dir %_cachedir/app-info/xmls
%_man1dir/appstreamcli.1.*
%_datadir/gettext/its/metainfo.*
%_datadir/metainfo/org.freedesktop.appstream.cli.*.xml

%files -n libappstream
%_libdir/libappstream.so.*
%_libdir/girepository-1.0/AppStream-1.0.typelib

%files -n libappstream-devel
%_includedir/appstream/
%_libdir/libappstream.so
%_libdir/pkgconfig/appstream.pc
%_datadir/gir-1.0/AppStream-1.0.gir

%files -n libappstream-qt
%_libdir/libAppStreamQt.so.*

%files -n libappstream-qt-devel
%_includedir/AppStreamQt/
%_libdir/cmake/AppStreamQt/
%_libdir/libAppStreamQt.so

%files doc
%_defaultdocdir/%name
%_datadir/gtk-doc/html/appstream

%changelog
