Summary: QEMU GUI written in Qt5
Name: aqemu
Version: 0.9.4
Release: alt3
Epoch: 1
License: GPL-2.0 and Zlib and MIT
Group: Emulators
Packager: Boris Savelev <boris@altlinux.org>
Url: https://github.com/tobimensch/aqemu
Source: %name-%version.tar
# Source-url: https://github.com/tobimensch/aqemu/archive/%version/aqemu-%version.tar.gz

BuildRequires(pre): cmake rpm-build-ninja
BuildRequires: gcc-c++ libvncserver-devel ImageMagick
BuildRequires: qt5-base-devel
BuildRequires: qt5-tools
Requires: qemu qemu-kvm

%description
AQEMU is a QEMU GUI written in Qt5.
The program have user-friendly interface and allows to set up the majority of QEMU options.

%prep
%setup
# gcc10
sed -i 's|#include <vector>|#include <vector>\n#include <stdexcept>|' src/docopt/docopt_value.h

%build
PATH=%_datadir/qt5/bin:$PATH; export PATH
%cmake_insource \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
#
cmake --build "%_cmake__builddir" -j1

%install
%cmake_install
mkdir -p %buildroot%_desktopdir
install -d %buildroot{%_niconsdir,%_miconsdir,%_liconsdir}
convert -size 16x16 ./resources/icons/aqemu.png %buildroot%_miconsdir/%name.png
convert -size 32x32 ./resources/icons/aqemu.png %buildroot%_niconsdir/%name.png
convert -size 48x48 ./resources/icons/aqemu.png %buildroot%_liconsdir/%name.png
rm -rf %buildroot%_datadir/doc/%name

%files
%doc README* AUTHORS* CHANGELOG* TODO*
%_bindir/%name
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/appdata/aqemu.appdata.xml
%_desktopdir/%name.desktop
%_liconsdir/%name.png
%_miconsdir/%name.png
%_niconsdir/%name.png
%_man1dir/%{name}*
%_pixmapsdir/*.png

%changelog
