Name: arpwatch
Version: 2.1a15
Release: alt8
Epoch: 2

%define arpwatch_user _arpwd
%define arpwatch_group _arpwd

Summary: Network monitoring tools for tracking IP addresses on the network
Group: Monitoring
License: BSD
Url: http://ee.lbl.gov/

# ftp://ftp.ee.lbl.gov/%name-%version.tar.gz
Source: arpwatch-%version.tar
Source1: arpwatch.init
Source2: arpwatch.sysconfig
Source3: arpwatch.service

Patch: arpwatch-%version-%release.patch

Requires: MTA
PreReq: shadow-utils

# Automatically added by buildreq on Tue Oct 31 2006
BuildRequires: libpcap-devel

%define _vararpwatch %_localstatedir/%name

%description
The %name package contains %name and arpsnmp.  Arpwatch and arpsnmp
are both network monitoring tools.  Both utilities monitor Ethernet or
FDDI network traffic and build databases of Ethernet/IP address pairs,
and can report certain changes via email.

Install the %name package if you need networking monitoring devices
which will automatically keep traffic of the IP addresses on your
network.

%prep
%setup
%patch -p1

%build
export ac_cv_path_V_SENDMAIL=%_sbindir/sendmail
%autoreconf
%configure

%make_build ARPDIR=%_vararpwatch

%install
mkdir -p %buildroot{%_vararpwatch,%_sbindir,%_man8dir,%_initdir,%_unitdir}
mkdir -p %buildroot/etc/sysconfig
%makeinstall_std install-man

install -pm755 arp2ethers massagevendor %buildroot%_vararpwatch/
install -pm644 *.awk *.dat %buildroot%_vararpwatch/

install -pm644 %_sourcedir/arpwatch.service %buildroot%_unitdir/
install -pm755 %_sourcedir/arpwatch.init %buildroot%_initdir/%name
install -pm644 %_sourcedir/arpwatch.sysconfig %buildroot/etc/sysconfig/%name

%pre
%_sbindir/groupadd -r -f %arpwatch_group
%_sbindir/useradd -r -g %arpwatch_group -c 'The arpwatch daemon' \
	-d %_vararpwatch -s /dev/null %arpwatch_user >/dev/null 2>&1 ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%_sbindir/*
%_mandir/man?/*
%_unitdir/*
%config(noreplace) %_initdir/%name
%config(noreplace) /etc/sysconfig/%name
%attr(1775,root,%arpwatch_group) %dir %_vararpwatch
%attr(644,%arpwatch_user,%arpwatch_group) %config(noreplace) %_vararpwatch/arp.dat
%_vararpwatch/ethercodes.dat
%_vararpwatch/*.awk
%_vararpwatch/arp2ethers
%_vararpwatch/massagevendor
%doc README CHANGES

%changelog
