Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           auto
Summary:        Collection of source code generators for Java
Version:        1.5.4
Release:        alt1_6jpp11
License:        ASL 2.0

URL:            https://github.com/google/auto
# Source tarball is generated by script to ensure the correct tagged
# code is fetched for the various submodules
Source0:        auto-value-%{version}.tar.gz
Source1:        gen_auto_tarball.sh

BuildRequires:  maven-local
BuildRequires:  mvn(com.squareup:javapoet)

BuildArch:      noarch
Source44: import.info

%description
The Auto sub-projects are a collection of code generators
that automate those types of tasks.


%package common
Group: Development/Java
Summary:        Auto Common Utilities
# Obsoletes added in F30
Obsoletes:      %{name}-factory < %{version}-%{release}

%description common
Common utilities for creating annotation processors.


%package service
Group: Development/Java
Summary:        Provider-configuration files for ServiceLoader

%description service
A configuration/meta-data generator for
java.util.ServiceLoader-style service
providers.


%package value
Group: Development/Java
Summary:        Auto Value

%description value
Immutable value-type code generation for Java 1.6+.


%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.


%prep
%setup -q -n auto-value-%{version}
find -name '*.class' -print -delete
find -name '*.jar' -print -delete

# remove unnecessary dependency on parent POM
%pom_remove_parent

# Disable factory module due to missing dep:
# com.google.googlejavaformat:google-java-format
%pom_disable_module factory build-pom.xml

# Fix deps in service module
%pom_xpath_set "pom:parent/pom:version" 6 service
%pom_change_dep com.google.auto:auto-common com.google.auto:auto-common:0.10 service

%pom_remove_plugin org.apache.maven.plugins:maven-checkstyle-plugin
%pom_remove_plugin :maven-shade-plugin value
%pom_remove_plugin :maven-invoker-plugin value

# Broader guava compatibility
sed -i -e 's/23.5-jre/20.0/' pom.xml
sed -i -e 's/toImmutableMap/toMap/' -e 's/static com.google.common.collect.ImmutableMap/static java.util.stream.Collectors/' \
  -e '/elementValues/s/ImmutableMap/Map/' \
  common/src/main/java/com/google/auto/common/SimpleAnnotationMirror.java
sed -i -e 's/toImmutableSet/toSet/' -e 's/static com.google.common.collect.ImmutableSet/static java.util.stream.Collectors/' \
  -e '/ImmutableSet</s/ImmutableSet/Set/' \
  service/src/main/java/com/google/auto/service/processor/AutoServiceProcessor.java

%mvn_package :build-only __noinstall


%build
# skip test suite because of unpackaged dependencies for tests
%mvn_build -sf -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8 -f build-pom.xml


%install
%mvn_install


%files -f .mfiles-%{name}-parent
%dir %{_javadir}/%{name}
%doc README.md
%doc --no-dereference LICENSE.txt

%files common -f .mfiles-%{name}-common
%doc common/README.md
%doc --no-dereference LICENSE.txt

%files service -f .mfiles-%{name}-service
%doc service/README.md
%doc --no-dereference LICENSE.txt

%files value -f .mfiles-%{name}-value
%doc value/README.md
%doc --no-dereference LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt


%changelog
