%define realname automake
%define dialect _1.16
%define dialect_regex _1\\.16
%define suff -1.16
%define apiname %realname%suff

Name: %realname%dialect
Version: 1.16.3
Release: alt1

%define mydatadir %_datadir/%apiname
%set_compress_method xz
%define _perl_lib_path %perl_vendor_privlib:%mydatadir
%{?filter_from_requires:%filter_from_requires /^perl(\(Automake\|TAP\)/d}
%{?filter_from_provides:%filter_from_provides /^perl(/d}

Summary: A GNU tool for automatically creating Makefiles
License: GPL-2.0-or-later and GFDL-1.3-or-later
Group: Development/Other
Url: https://www.gnu.org/software/automake/
BuildArch: noarch

%define srcname %realname-%version-%release

# git://git.altlinux.org/gears/a/%name.git
Source: %srcname.tar

Requires: automake-common, autoconf >= 2:2.69

# Due to Automake History.
Conflicts: automake_1.14 < 1.14.1-alt5

BuildPreReq: autoconf >= 2:2.69, gnu-config, help2man, makeinfo, perl-threads
BuildPreReq: perl(TAP/Parser.pm)
%{!?__buildreqs:%{!?_without_check:%{!?_disable_check:BuildRequires: dejagnu expect flex gcc-c++ gcc-fortran makedepend}}}

%description
Automake is a tool for automatically generating `Makefile.in'
files compliant with the GNU Coding Standards.

%prep
%setup -n %srcname
xz -k9 NEWS

# Patch texinfo file.
sed -i \
	-e '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].-]\+\)\(:[[:space:]]\+\)(%realname)/\1\2(%apiname)/' \
	-e '/^@\(setfilename\|settitle\)[[:space:]]\+%realname/ s//&%suff/' \
	doc/automake.texi

%build
%define docdir %_docdir/%realname-%version
./bootstrap
%configure --docdir=%docdir --disable-silent-rules
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std MAKEINFOFLAGS=--no-split

# Provided by automake-common package.
rm %buildroot%_aclocaldir/README

# Provided by automake package.
rm %buildroot%_bindir/{aclocal,automake}
rm %buildroot%_man1dir/{aclocal,automake}.1*

# Replace config.* copies with symlinks to original files.
for f in %_datadir/gnu-config/config.*; do
	[ -f "$f" ] || continue
	ln -frs %buildroot"$f" %buildroot%mydatadir/"${f##*/}"
done

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^/usr/share/aclocal(%dialect_regex)?/.+\.m4$
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

install -pm644 AUTHORS README THANKS NEWS.* \
	%buildroot%docdir/

# Reenable perl-threads dependencies.
# Do not use automake from the OS during generation of package dependencies.
%define __spec_autodep_custom_pre export AUTOMAKE_JOBS=1 AUTOMAKE_UNINSTALLED=1

%define _unpackaged_files_terminate_build 1
# This has no effect on this noarch package, but let it be.
%set_verify_elf_method strict

%check
%make_build -k check VERBOSE=1
chmod -R u+rwX t

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/*
%_bindir/*%suff
%_man1dir/*%suff.1*
%_datadir/aclocal%suff
%mydatadir/
%_infodir/*.info*
%docdir/

%changelog
