Name: backupninja
Version: 1.2.1
Release: alt1

Summary: backup system
License: GPL v2
Group: Archiving/Backup

Url: https://0xacab.org/riseuplabs/backupninja

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://0xacab.org/riseuplabs/backupninja/repository/%name-%version/archive.tar.bz2
Source: %name-%version.tar

BuildArch: noarch

Requires: %_sysconfdir/cron.d %_sysconfdir/logrotate.d dialog bash4

BuildRequires: bash4

BuildRequires: rpm-macros-intro-conflicts

%description
Backupninja lets you drop simple config files in %_sysconfdir/backup.d to coordinate
system backups. Backupninja is a master of many arts, including incremental
remote filesystem backup, mysql backup, and ldap backup. By creating simple
drop-in handler scripts, backupninja can learn new skills. Backupninja is a
silent flower blossom death strike to lost data.

In addition to backing up regular files, Backupninja has handlers to ease
backing up: ldap, maildir, mysql, svn, trac, and the output from shell scripts.

Backupninja currently supports common backup utilities, easing their
configuration, currently supported are: rdiff-backup, duplicity, restic, borg, CD/DVD.

%prep
%setup
# lib/Makefile.am:1: `pkglibdir' is not a legitimate directory for `SCRIPTS'
%__subst "s|(pkglib|(pkglibexec|g" */Makefile.am
%__subst "s|pkglib_SCRIPTS|pkglibexec_SCRIPTS|g" lib/Makefile.am
# HACK: use bash4
%__subst "s|bash|bash4|g" configure.ac

%build
%autoreconf
%configure
%make_build

%install
%makeinstall
mkdir -p %buildroot%_sysconfdir/backup.d/

%files
%doc README.md TODO AUTHORS
%config(noreplace) %_sysconfdir/%name.conf
%_sysconfdir/cron.d/%name
%_sysconfdir/logrotate.d/%name
%attr(0700,root,root) %dir %_sysconfdir/backup.d/
%_datadir/%name/
%_libexecdir/%name/
%_man1dir/%name.1*
%_man1dir/ninjahelper.1*
%_man5dir/backup.d.5*
%_man5dir/%name.conf.5*
%_sbindir/%name
%_sbindir/ninjahelper

%changelog
