Name: beecrypt
Version: 4.2.1
Release: alt7

Summary: The BeeCrypt Cryptography Library
License: LGPLv2+
Group: System/Libraries
Url: http://sourceforge.net/projects/beecrypt

Source: beecrypt-%version.tar
Patch1: beecrypt-4.1.2-rh-biarch.patch
Patch2: beecrypt-4.2.1-rh-no-c++.patch
Patch3: beecrypt-4.2.1-alt-arm.patch
Patch4: beecrypt-4.2.1-alt-assert.patch

%define soname 7

%package -n lib%name%soname
Summary: The BeeCrypt Cryptography Library
Group: System/Libraries
Provides: %name = %version-%release
Provides: lib%name = %version-%release
Obsoletes: %name

%package -n lib%name-devel
Summary: Development environment for the BeeCrypt Cryptography Library
Group: Development/C
Provides: %name-devel = %version-%release
Obsoletes: %name-devel
Requires: lib%name%soname = %version-%release

%package -n lib%name-devel-static
Summary: Static version of the BeeCrypt Cryptography Library
Group: Development/C
Provides: %name-devel-static = %version-%release
Obsoletes: %name-devel-static
Requires: lib%name-devel = %version-%release

%description
BeeCrypt is an open source cryptography library that contains
highly optimized C and assembler implementations of many
well-known algorithms including Blowfish, MD5, SHA-1,
Diffie-Hellman, and ElGamal.

%description -n lib%name%soname
BeeCrypt is an open source cryptography library that contains
highly optimized C and assembler implementations of many
well-known algorithms including Blowfish, MD5, SHA-1,
Diffie-Hellman, and ElGamal.

%description -n lib%name-devel
BeeCrypt is an open source cryptography library that contains
highly optimized C and assembler implementations of many
well-known algorithms including Blowfish, MD5, SHA-1,
Diffie-Hellman, and ElGamal.

This package contains development files required for building
BeeCrypt-based software.

%description -n lib%name-devel-static
BeeCrypt is an open source cryptography library that contains
highly optimized C and assembler implementations of many
well-known algorithms including Blowfish, MD5, SHA-1,
Diffie-Hellman, and ElGamal.

This package contains static library required for building
BeeCrypt-based statically linked software.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p2
%patch4 -p2
bzip2 -9k BENCHMARKS

%build
%autoreconf

%configure \
	--enable-static \
	%{subst_enable debug} \
	--with-cplusplus=no \
	--with-java=no \
	--with-python=no \
	#
%make_build

%install
%makeinstall_std

iconv -f ISO-8859-1 -t UTF-8 CONTRIBUTORS -o CONTRIBUTORS.utf8
mv -f CONTRIBUTORS.utf8 CONTRIBUTORS

%check
%make_build -k check

%files -n lib%name%soname
%_libdir/*.so.*
%doc AUTHORS BENCHMARKS.bz2 BUGS CONTRIBUTORS NEWS README

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
