%def_disable snapshot

%define ver_major 40
%define xdg_name org.gnome.Notes
%define _libexecdir %_prefix/libexec
# dropped since 40.0
%def_disable zeitgeist

Name: bijiben
Version: %ver_major.1
Release: alt1

Summary: Note editor for GNOME
License: GPL-3.0
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Bijiben

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.54
%define gtk_ver 3.20
%define tracker_api_ver 3.0
%define tracker_ver 3.0
%define eds_ver 3.34.0
%define webkit_ver 2.26

Requires: dconf tracker-miners3 >= %tracker_ver

BuildRequires(pre): meson rpm-build-xdg
BuildRequires: yelp-tools libappstream-glib-devel
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: pkgconfig(tracker-sparql-%tracker_api_ver) >= %tracker_ver
BuildRequires: libxml2-devel libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libgnome-online-accounts-devel libuuid-devel
BuildRequires: evolution-data-server-devel >= %eds_ver libcurl-devel
BuildRequires: libical-devel libicu-devel libjson-glib-devel
BuildRequires: pkgconfig(libhandy-1)
%{?_enable_zeitgeist:BuildRequires: libzeitgeist2.0-devel}

%description
Bijiben is an attempt to design an intuitive note editor with strong
desktop integration.

%prep
%setup

%build
%meson \
	%{?_enable_zeitgeist:-Dzeitgeist=true} \
	-Dupdate_mimedb=false
# SMP-incompatible build
%meson_build -j 1

%install
%meson_install
%find_lang --with-gnome %name

%check
%meson_test

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-shell-search-provider
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_datadir/dbus-1/services/%xdg_name.SearchProvider.service
%_xdgmimedir/packages/%xdg_name.xml
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README* AUTHORS NEWS

%changelog
