%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,lint=relaxed
%define git %nil
%define llvm_ver 11.0

%def_with docs

%ifarch aarch64 x86_64 %e2k
%def_with embree
%else
%def_without embree
%endif

%def_without clang
%def_without cuda
%def_without openpgl
%def_without usd

%ifarch x86_64
%def_with oidn
%def_with hip
%else
%def_without oidn
%def_without hip
%endif

%if_with clang
%def_with lld
%endif

%ifarch %e2k
# error: cpio archive too big - 4690M
%define optflags_debug -g0
%endif

%def_with jemalloc

Name: blender
Version: 3.3.21
Release: alt0.p10.1
Summary: 3D modeling, animation, rendering and post-production
License: GPL-3.0-or-later
Group: Graphics
URL: https://www.blender.org

# Blender doesn't officially support 32-bit build since 2.80. See also:
# https://developer.blender.org/T67184
ExcludeArch: %ix86 %arm

# git://git.blender.org/blender.git
Source: %name-%version.tar

# git submodules
# before updating submodules via script don't forget
# to update relative submodule paths into absolute ones
Source1: %name-%version-release-scripts-addons_contrib.tar
Source2: %name-%version-release-scripts-addons.tar
Source3: %name-%version-release-datafiles-locale.tar
Source4: %name-%version-source-tools.tar

Patch21: blender-2.66-alt-pcre.patch
Patch22: blender-2.77-alt-enable-localization.patch
Patch23: blender-2.92-alt-include-deduplication-check-skip.patch
Patch24: blender-2.80-alt-use-system-glog.patch
# TODO not sure we need this patch
Patch25: blender-2.90.0-alt-embree-components.patch
Patch26: blender-3.0.0-alt-doc.patch
Patch27: blender-2.90-alt-non-x86_64-linking.patch
Patch28: blender-2.93.0-suse-reproducible.patch
Patch29: blender-alt-fix-clang-linking.patch
Patch30: blender-alt-osl-shader-dir.patch

BuildRequires(pre): rpm-build-python3 cmake
BuildRequires: boost-filesystem-devel boost-locale-devel boost-wave-devel
BuildRequires: libGLEW-devel libXi-devel
BuildRequires: libavdevice-devel libavformat-devel libavfilter-devel libswresample-devel
BuildRequires: libfftw3-devel libjack-devel libopenal-devel libsndfile-devel
BuildRequires: libjpeg-devel >= 2.1.3 pkgconfig(libopenjp2) libpng-devel libtiff-devel libpcre-devel libswscale-devel libxml2-devel
BuildRequires: liblzo2-devel
%if_with clang
BuildRequires: libopenCOLLADA-devel >= 0-alt8
%else
BuildRequires: libopenCOLLADA-devel >= 0-alt3
%endif
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: libopenimageio-devel
BuildRequires: libopencolorio2.0-devel
BuildRequires: openexr-devel
BuildRequires: ilmbase-devel
BuildRequires: libpugixml-devel
BuildRequires: libglog-devel libgflags-devel eigen3-devel
BuildRequires: libXxf86vm-devel libXrender-devel
BuildRequires: tbb-devel
BuildRequires: libfreetype-devel
# Remove following dependency when libopenjpeg2.0-devel is fixed
BuildRequires: openjpeg-tools2.0
BuildRequires: alembic-devel
BuildRequires: openvdb-devel libblosc-devel
BuildRequires: libgomp-devel
BuildRequires: libgmp-devel libgmpxx-devel
BuildRequires: libharu-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libpotrace-devel
BuildRequires: openshadinglanguage-devel llvm%{llvm_ver}-devel
BuildRequires: opensubdiv-devel
BuildRequires: libzstd-devel
BuildRequires: libepoxy-devel
BuildRequires: libxkbcommon-devel
BuildRequires: libvulkan-devel
BuildRequires: libspnav-devel
BuildRequires: libwebp-devel
%ifarch aarch64
BuildRequires: sse2neon-devel
%endif

%if_with embree
BuildRequires: embree-devel
%endif

%if_with jemalloc
BuildRequires: libjemalloc-devel
%endif

%if_with docs
BuildRequires: /usr/bin/doxygen
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink python3-module-sphinx_rtd_theme
%endif

%if_with clang
BuildRequires: clang%{llvm_ver} libstdc++-devel
%else
BuildRequires: gcc-c++
%endif

%if_with lld
BuildRequires: lld%{llvm_ver}
%endif

%if_with hip
BuildRequires: hip-devel
%endif

%if_with openpgl
BuildRequires: openpgl-devel
%endif

%if_with usd
BuildRequires: OpenUSD-devel
%endif

%if_with cuda
BuildRequires: nvidia-cuda-devel
# .cubin files are ELF files but we still don't know how
# to handle them.
%set_verify_elf_skiplist %_datadir/%name/*/scripts/addons/cycles/lib/*.cubin
%endif

%if_with oidn
BuildRequires: openimagedenoise-devel
%endif

%add_python3_path %_datadir/%name/scripts
%add_python3_req_skip _bpy
%add_python3_req_skip _bpy_path
%add_python3_req_skip _cycles
%add_python3_req_skip _freestyle
%add_python3_req_skip bgl
%add_python3_req_skip blend
%add_python3_req_skip blf
%add_python3_req_skip idprop.types
%add_python3_req_skip gpu
%add_python3_req_skip io_scene_gltf2.blender.com
%add_python3_req_skip io_scene_gltf2.blender.exp
%add_python3_req_skip io_scene_gltf2.io.com
%add_python3_req_skip io_scene_gltf2.io.exp
%add_python3_req_skip mathutils
%add_python3_req_skip mathutils.bvhtree
%add_python3_req_skip mathutils.geometry
%add_python3_req_skip mathutils.noise
%add_python3_req_skip oscurart_tools.files
%add_python3_req_skip oscurart_tools.mesh
%add_python3_req_skip oscurart_tools.object
%add_python3_req_skip oscurart_tools.render
%add_python3_req_skip setuptools
%add_python3_req_skip bmesh
%add_python3_req_skip bpy.app.handlers
%add_python3_req_skip bpy.app.translations
%add_python3_req_skip bpy.props
%add_python3_req_skip bpy.types

AutoProv: no

Obsoletes: %name-i18n

%description
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation

%description -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

%package doc
Summary: Documentation for Blender
Group: Documentation
Requires: %name = %EVR

%description doc
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation.

This package contains documentation for Blender.

%description doc -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

Данный пакет содержит документацию для Blender.

%package cycles-hip-kernels
Summary: Cycles precompiled binaries for HIP
Group: System/Libraries
Requires: %name = %EVR, hip-runtime-amd

%description cycles-hip-kernels
Precompiled GPU binaries for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for AMD GPUs to use with HIP.

%package cycles-nvidia-kernels
Summary: Cycles precompiled binaries for CUDA
Group: System/Libraries
Requires: %name = %EVR, libcuda

%description cycles-nvidia-kernels
Precompiled GPU binaries for GPU accelerated rendering with Cycles on various
graphics cards.

This package contains binaries for Nvidia GPUs to use with CUDA.

%prep
%setup -a1 -a2 -a3 -a4

%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
#%%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1
%patch29 -p1
%patch30 -p1

%ifarch %e2k
#%%patch2000 -p1
# lcc 1.25.15's EDG bug would fail building OPENVDB+TBB otherwise
sed -i "/-Werror=return-type/d" CMakeLists.txt
sed -i 's/"${CMAKE_C_COMPILER_VERSION}" VERSION_LESS/"100" VERSION_LESS/' CMakeLists.txt
%endif

# Delete the bundled FindOpenJPEG to make find_package use the system version
# instead (the local version hardcodes the openjpeg version so it is not update
# proof)
rm -f build_files/cmake/Modules/FindOpenJPEG.cmake

# Remove bundled libraries which must not be used instead of system ones
rm -rf extern/{Eigen3,glew,lzo,gflags,glog}

%build
BUILD_DATE="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%Y-%%m-%%d')"
BUILD_TIME="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%H:%%M:%%S')"

# Explicitly use python3 in hashbangs.
pushd release/scripts/addons
subst '/^#!.*python$/s|python$|python3|' $(grep -Rl '#!.*python$' *)
popd

# needed due to non-standard location of pcre.h header
%add_optflags -I%_includedir/pcre

%ifarch aarch64
# limit build jobs on aarch64
if [ %__nprocs -gt 48 ] ; then
	export NPROCS=48
fi
%endif
%if_with clang
export ALTWRAP_LLVM_VERSION=%{llvm_ver}
%endif
%cmake \
	-DLIBDIR=OFF \
	-DWITH_SYSTEM_GLEW=ON \
%if_with clang
	-DWITH_LLVM=ON \
	-DWITH_CLANG=ON \
	-DCMAKE_C_COMPILER=clang \
	-DCMAKE_CXX_COMPILER=clang++ \
%endif
%if_with hip
	-DWITH_CYCLES_HIP_BINARIES:BOOL=ON \
%endif #hip
%if_with cuda
	-DWITH_CYCLES_CUDA_BINARIES:BOOL=ON \
%endif #cuda
	-DBUILD_SHARED_LIBS=OFF \
	-DWITH_ALEMBIC:BOOL=ON \
	-DWITH_FFTW3=ON \
	-DWITH_JACK=ON \
	-DWITH_CODEC_SNDFILE=ON \
	-DWITH_IMAGE_OPENJPEG=ON \
	-DWITH_PYTHON=ON \
	-DWITH_PYTHON_INSTALL=OFF \
	-DWITH_CODEC_FFMPEG=ON \
	-DWITH_CXX_GUARDEDALLOC=OFF \
	-DWITH_INSTALL_PORTABLE=OFF \
	-DWITH_PYTHON_SAFETY=OFF \
	-DWITH_OPENMP=ON \
	-DWITH_OPENCOLLADA=ON \
	-DWITH_CYCLES=ON \
%if_with embree
	-DEMBREE_ROOT_DIR=%_prefix \
	-DWITH_CYCLES_EMBREE:BOOL=ON \
%else
	-DWITH_CYCLES_EMBREE:BOOL=OFF \
%endif
%if_with usd
	-DWITH_USD:BOOL=ON \
%else
	-DWITH_USD:BOOL=OFF \
%endif
	-DWITH_OPENCOLORIO=ON \
	-DWITH_OPENVDB:BOOL=ON \
	-DWITH_OPENVDB_BLOSC:BOOL=ON \
	-DWITH_SYSTEM_LZO=ON \
	-DWITH_SYSTEM_EIGEN3:BOOL=ON \
	-DWITH_SYSTEM_GFLAGS:BOOL=ON \
	-DWITH_SYSTEM_GLOG:BOOL=ON \
	-DWITH_SYSTEM_FREETYPE:BOOL=ON \
	-DWITH_IMAGE_OPENEXR=ON \
	-DWITH_TBB:BOOL=ON \
	-DPYTHON_VERSION="%_python3_version" \
	-DBUILDINFO_OVERRIDE_DATE="$BUILD_DATE" \
	-DBUILDINFO_OVERRIDE_TIME="$BUILD_TIME" \
	-DWITH_DOC_MANPAGE:BOOL=ON \
	-DWITH_ASSERT_ABORT:BOOL=OFF \
	-DWITH_LINKER_GOLD:BOOL=OFF \
	-DWITH_OPENSUBDIV:BOOL=ON \
%if_with lld
	-DWITH_LINKER_LLD:BOOL=ON \
	-DCMAKE_EXE_LINKER_FLAGS:STRING="-Wl,--build-id=sha1" \
	-DCMAKE_SHARED_LINKER_FLAGS:STRING="-Wl,--build-id=sha1" \
	-DCMAKE_MODULE_LINKER_FLAGS:STRING="-Wl,--build-id=sha1" \
%endif
	-DOPENEXR_INCLUDE_DIRS=%_includedir/OpenEXR \
	%nil

%cmake_build

%if_with docs
pushd doc/doxygen
doxygen -u Doxyfile
doxygen
popd
%endif

%install
%cmake_install

mkdir -p %buildroot%_datadir/metainfo
install -m644 release/freedesktop/*.appdata.xml %buildroot%_datadir/metainfo/

%files
%_bindir/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_datadir/%name/
%if_with hip
%exclude %_datadir/%name/*/scripts/addons/cycles/lib/kernel_gfx*.fatbin
%endif
%if_with cuda
%exclude %_datadir/%name/*/scripts/addons/cycles/lib/kernel_compute*.ptx
%exclude %_datadir/%name/*/scripts/addons/cycles/lib/kernel_sm_*.cubin
%endif
%_datadir/metainfo/*.appdata.xml
%_defaultdocdir/%name/
%_man1dir/%name.1*

%if_with hip
%files cycles-hip-kernels
%_datadir/%name/*/scripts/addons/cycles/lib/kernel_gfx*.fatbin
%endif

%if_with cuda
%files cycles-nvidia-kernels
%_datadir/%name/*/scripts/addons/cycles/lib/kernel_compute*.ptx
%_datadir/%name/*/scripts/addons/cycles/lib/kernel_sm_*.cubin
%endif

%if_with docs
%files doc
%doc doc/doxygen/html
%endif

%changelog
