Name: borg
Version: 1.1.17
Release: alt2

Summary: Deduplicating backup program with compression and authenticated encryption

License: BSD-3-Clause
Group: File tools
Url: https://borgbackup.github.io/borgbackup/

# Source-url: https://github.com/borgbackup/borg/archive/%version.tar.gz
Source: %name-%version.tar
Patch1: borg-unbundle-xxhash-1.1.10.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: gcc-c++
BuildRequires: libacl-devel ipython3 python3-module-Cython libssl-devel python3-dev
BuildRequires: python3-module-setuptools_scm
BuildRequires: liblz4-devel libzstd-devel libb2-devel libxxhash-devel

#Requires: python3-module-msgpack >= 0.4.6
Requires: python3-module-zmq

%description
BorgBackup (short: Borg) is a deduplicating backup program.
Optionally, it supports compression and authenticated encryption.

The main goal of Borg is to provide an efficient and secure way to backup data.
The data deduplication technique used makes Borg suitable for daily backups
since only changes are stored.

The authenticated encryption technique makes it suitable for backups to not
fully trusted targets.

%prep
%setup
#patch1 -p1

#rm -rfv src/borg/algorithms/{lz4,xxh64,zstd,blake2}/
#rm -rfv src/borg/algorithms/{lz4,zstd,blake2}/

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install

%files
%doc LICENSE AUTHORS CHANGES.rst README.rst
%_bindir/borg
%_bindir/borgfs
%python3_sitelibdir/borg/
%python3_sitelibdir/borgbackup-*.egg-info/


%changelog
