Group: Development/Other
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           bsf
Epoch:          1
Version:        2.4.0
Release:        alt3_39jpp11
Summary:        Bean Scripting Framework
License:        ASL 2.0
URL:            http://commons.apache.org/bsf/
BuildArch:      noarch

Source0:        http://apache.mirror.anlx.net//commons/%{name}/source/%{name}-src-%{version}.tar.gz
Source1:        %{name}-pom.xml

Patch0:         java-11-fixes.patch

BuildRequires:  javapackages-local
BuildRequires:  ant
BuildRequires:  apache-commons-logging
BuildRequires:  apache-parent
BuildRequires:  rhino
BuildRequires:  xalan-j2
Source44: import.info
%add_findreq_skiplist /usr/share/bsf-*

%description
Bean Scripting Framework (BSF) is a set of Java classes which provides
scripting language support within Java applications, and access to Java
objects and methods from scripting languages. BSF allows one to write
JSPs in languages other than Java while providing access to the Java
class library. In addition, BSF permits any Java application to be
implemented in part (or dynamically extended) by a language that is
embedded within it. This is achieved by providing an API that permits
calling scripting language engines from within Java, as well as an
object registry that exposes Java objects to these scripting language
engines.

BSF supports several scripting languages currently:
* Javascript (using Rhino ECMAScript, from the Mozilla project)
* Python (using either Jython or JPython)
* Tcl (using Jacl)
* NetRexx (an extension of the IBM REXX scripting language in Java)
* XSLT Stylesheets (as a component of Apache XML project's Xalan and
Xerces)

In addition, the following languages are supported with their own BSF
engines:
* Java (using BeanShell, from the BeanShell project)
* JRuby
* JudoScript

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
Javadoc for %{name}.

%prep
%setup -q
%patch0 -p1

find -name \*.jar -delete

%mvn_file : %{name}
%mvn_alias : org.apache.bsf:

%build
export CLASSPATH=$(build-classpath apache-commons-logging rhino xalan-j2)
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  jar javadocs

%mvn_artifact %{SOURCE1} build/lib/%{name}.jar

%install
%mvn_install -J build/javadocs

%files -f .mfiles
%doc --no-dereference LICENSE.txt NOTICE.txt
%doc AUTHORS.txt CHANGES.txt README.txt TODO.txt RELEASE-NOTE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt NOTICE.txt

%changelog
