%define _unpackaged_files_terminate_build 1
# change libcares package name according to SharedLibsPolicy in future
%define soname 2

Name: c-ares
Version: 1.26.0
Release: alt1

Summary: A library that performs asynchronous DNS operations
License: MIT
Group: System/Libraries

Url: http://c-ares.haxx.se/
Source: %url/download/c-ares-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
# need for test/configure
BuildRequires: gcc-c++
BuildRequires: libgtest-devel

%description
c-ares is a C library that performs DNS requests and name resolves
asynchronously. This package contains little utilities built with
this library.

%package -n libcares
Summary: A library that performs asynchronous DNS operations
Group: System/Libraries

%description -n libcares
c-ares is a C library that performs DNS requests and name resolves
asynchronously. c-ares is a fork of the library named 'ares', written
by Greg Hudson at MIT.

%package -n libcares-devel
Summary: Libraries, includes, etc. to develop applications used c-ares
Group: System/Libraries
Requires: libcares = %version-%release

%description -n libcares-devel
This package contains the header files and libraries links needed to
compile applications or shared objects that use c-ares.

%prep
%setup -n c-ares-%version
%patch0 -p1

%build
%cmake -DCMAKE_INSTALL_LIBDIR:PATH="%_libdir" -DCARES_BUILD_TESTS:BOOL=ON
%cmake_build

%install
%cmake_install

%check
%_cmake__builddir/bin/arestest --gtest_filter=-*.Live*

%files
%_bindir/*
%_man1dir/*

%files -n libcares
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files -n libcares-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/%name
%_man3dir/*

%changelog
