#set_automake_version 1.11

Name: cdcd
Version: 0.6.6
Release: alt6.git20140208.1
Summary: Command Driven CD player
License: %gpl2plus
Group: Sound
URL: http://libcdaudio.sourceforge.net/
# git://git.code.sf.net/p/libcdaudio/cdcd
Source: %name-%version.tar

BuildRequires(pre): rpm-build-licenses
BuildRequires: glib2-devel libcdaudio-devel libreadline-devel
BuildPreReq: libsocket-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
%name takes a different approach from conventional console (or X) based
CD players, in that it doesn't keep with the display-oriented paradigm.
Conventional computer-based CD players resemble traditional physical CD
players. This is fine, if your user interface consists of 10 buttons.
However, computers have keyboards, so why not use them? Besides, it's
certainly a waste of a console or an xterm to have a traditional CD
player open anyway.
%name works in two ways, accepting commands directly off the command
line or in a query mode similar to other UNIX programs. To pass a
command to %name, simply run %name with the command as the arguement
(e.g. %name play). This is great for using cron and %name together to
make a CD alarm clock. Or, you can run %name without arguments and you
will be given the %name command prompt.


%prep
%setup


%build
%define _optlevel s
%add_optflags -D_GNU_SOURCE
%autoreconf
%configure
%make_build
bzip2 --best --force --keep ChangeLog


%install
%make_install DESTDIR=%buildroot install

# menu
install -d %buildroot%_desktopdir
iconv -f cp1251 -t utf-8 > %buildroot%_desktopdir/%name.desktop <<__MENU__
[Desktop Entry]
GenericName=Command Driven CD player
GenericName[ru]=-   
GenericName[uk]=-   
Name=%name
Exec=%name
Icon=cdaudio_unmount
Type=Application
Terminal=true
Categories=AudioVideo;Audio;Player;ConsoleOnly;
__MENU__


%files
%doc README NEWS AUTHORS ChangeLog.*
%_bindir/*
%_infodir/*
%_man1dir/*
%_desktopdir/*


%changelog
