Name: chkrootkit
Version: 0.58b
Release: alt1

Summary: Check rootkits
Summary(ru_RU.UTF-8): Поиск троянских коней и закладок в программах

License: BSD-2-Clause
Group: Monitoring
Url: http://www.chkrootkit.org/

Source: ftp://ftp.pangeia.com.br/pub/seg/pac/%name-%version.tar.gz
Patch0: chkrootkit-alt-libpath.patch

BuildRequires: glibc-devel-static

Requires: binutils coreutils findutils sed gawk grep net-tools procps crontabs
Requires: /usr/bin/ssh

%define cron_daily %_sysconfdir/cron.daily

%description
chkrootkit is a tool to locally check for signs of a rootkit.
It contains:

* chkrootkit: shell script that checks system binaries for
  rootkit modification.
* ifpromisc: checks if the network interface is in promiscuous mode.
* chklastlog: checks for lastlog deletions.
* chkwtmp: checks for wtmp deletions.
* chkproc: checks for signs of LKM trojans.
* chkdirs: checks for signs of LKM trojans.
* strings: quick and dirty strings replacement.
* chkutmp: checks for utmp deletions.

%description -l ru_RU.UTF-8
Chkrootkit является набором утилит для поиска троянских коней и закладок
по набору сигнатур в программах на локальном компьютере.

%prep
%setup
%patch0 -p2
subst 's|@CHKROOTKIT_DIR@|%_libdir/%name|' %name

%build
make sense CC="%{__cc} $RPM_OPT_FLAGS -D_FILE_OFFSET_BITS=64"

%install
install -Dpm0755 chkrootkit %buildroot%_sbindir/chkrootkit

for p in \
	check_wtmpx  \
    chkdirs  \
    chklastlog  \
    chkproc  \
    chkutmp \
    chkwtmp  \
    ifpromisc  \
    strings-static \
    ; do
	install -pD -m 755 "$p" "%buildroot%_libdir/%name/$p"
done

mkdir -p %buildroot%cron_daily
cat > %buildroot%cron_daily/%name << __EOF__
%_sbindir/%name -q
__EOF__

%files
%doc COPYRIGHT ACKNOWLEDGMENTS README README.chklastlog README.chkwtmp chkrootkit.lsm
%_sbindir/*
%_libdir/%name
%attr(700,root,root) %cron_daily/%name

%changelog
