%define		_oldname	sylpheed-claws
%def_disable 	debug

%def_disable 	appdata
%def_enable 	svg
%ifnarch %e2k
%def_enable 	networkmanager
%else
%def_disable 	networkmanager
%endif

%def_enable		manual

# pligins
%def_enable 	archive
%def_disable	bsfilter
%ifnarch %e2k
%def_disable 	dillo
%def_enable 	fancy
%else
%def_enable 	dillo
%def_disable 	fancy
%endif
%def_enable 	litehtmlviewer
%ifnarch %e2k
# It is python2, so disable it.
%def_disable 	python
%else
%def_disable 	python
%endif
%def_enable 	tnef

%define _unpackaged_files_terminate_build 1

Name:   	claws-mail
Version:	3.21.0
Release: 	alt1

Summary:	Claws Mail is a GTK+ based, user-friendly, lightweight, and fast email client.
License: 	GPLv3+
Group: 		Networking/Mail

Url:		https://www.claws-mail.org
Vcs:		git://git.claws-mail.org/claws.git

Source: %name-%version.tar
Patch:	%name-%version-%release.patch

Obsoletes:	%_oldname < %version
Provides:	%_oldname

BuildPreReq:	autoconf-common gettext-tools

BuildRequires: flex libSM-devel libcompface-devel libdbus-glib-devel libenchant2-devel libgnutls-devel libgpgme-devel libldap-devel libstartup-notification-devel libgcrypt-devel zlib-devel
# For SNI support
BuildRequires: libetpan-devel >= 1.9.1-alt3
BuildRequires: libnettle-devel
BuildRequires: libgtk+2-devel
BuildRequires: rpm-build-python3
%{?_enable_svg:BuildRequires: librsvg-devel}
%{?_enable_networkmanager:BuildRequires: libnm-devel}
%{?_enable_manual:BuildRequires: docbook-utils lynx}

# For plugin-archive:
%if_enabled archive
BuildRequires: libarchive-devel
%endif

# For plugin-fancy, plugin-libravatar, plugin-litehtmlviewer, plugin-rssyl, plugin-spamreport, plugin-vcalendar
BuildRequires: libcurl-devel

# For plugin-fancy
%if_enabled fancy
BuildRequires: libwebkitgtk2-devel
BuildRequires: libsoup-gnome-devel
%endif

# For plugin-litehtmlviewer
%if_enabled litehtmlviewer
BuildRequires: gcc-c++
BuildRequires: libcairo-devel
BuildRequires: fontconfig-devel
BuildRequires: libgumbo-devel
%endif

# For plugin-rssyl
BuildRequires: libexpat-devel

# For plugin-pdfviewer
BuildRequires: libpoppler-glib-devel

# For plugin-perl
BuildRequires: perl-devel sed

# For pligin-python
%{?_enable_python:BuildRequires: python-devel python-module-pygtk-devel}

# For plugin-notification
%def_disable indicator
%def_enable hotkeys
BuildRequires: libnotify-devel
BuildRequires: libcanberra-gtk2-devel
%{?_enable_indicator:BuildRequires: libindicate-devel >=  0.3.0}
%{?_enable_hotkeys:BuildRequires: libgio-devel >= 2.15.6}

# For plugin-tnef
%if_enabled tnef
BuildRequires: libytnef-devel
%endif

# For vcalendar
BuildRequires: libical-devel

# For tools
BuildPreReq:	perl-MIME-tools
BuildPreReq:	perl-Text-Iconv
BuildPreReq:	perl-XML-SimpleObject
BuildPreReq:	perl-URI
BuildPreReq: 	perl-libwww
BuildPreReq: 	perl-Text-CSV_XS
BuildPreReq: 	perl-File-Which

%description
Claws Mail is an email client (and news reader), based on GTK+,
featuring

    Quick response
    Graceful, and sophisticated interface
    Easy configuration, intuitive operation
    Abundant features
    Extensibility

The appearance and interface are designed to be familiar to new users
coming from other popular email clients, as well as experienced users.
Almost all commands are accessible with the keyboard.

The messages are managed in the standard MH format, which features fast
access and data security. You'll be able to import your emails from
almost any other email client, and export them just as easily.

Lots of extra functionality, like an RSS aggregator, calendar, or laptop
LED handling, are provided by extra plugins.

Claws Mail is distributed under the GPL.

%package        devel
Summary:        Development environment for %name
Group:          Development/C
Requires:	%name = %version-%release
Obsoletes:	%_oldname-devel < %version
Provides:	%_oldname-devel

%description 	devel
This package contains the header files and libraries for building
program which use %name.

%package	plugins
Summary:	Install all plugins for %name
Group:		Networking/Mail
BuildArch:	noarch
Requires:	%name = %version-%release
Requires:	%name-plugin-acpinotifier = %version-%release
Requires:	%name-plugin-addresskeeper = %version-%release
%if_enabled archive
Requires:	%name-plugin-archive = %version-%release
%endif
Requires:	%name-plugin-attachwarner = %version-%release
Requires:	%name-plugin-attremover = %version-%release
Requires:	%name-plugin-bogofilter = %version-%release
%if_enabled bsfilter
Requires:	%name-plugin-bsfilter = %version-%release
%endif
Requires:	%name-plugin-clamd = %version-%release
%if_enabled dillo
Requires:	%name-plugin-dillo = %version-%release
%endif
%if_enabled fancy
Requires:	%name-plugin-fancy = %version-%release
%endif
Requires:	%name-plugin-fetchinfo = %version-%release
Requires:	%name-plugin-keywordwarner = %version-%release
Requires:	%name-plugin-libravatar = %version-%release
%if_enabled litehtmlviewer
Requires:	%name-plugin-litehtmlviewer = %version-%release
%endif
Requires:	%name-plugin-mailmbox = %version-%release
Requires:	%name-plugin-managesieve = %version-%release
Requires:	%name-plugin-newmail = %version-%release
Requires:	%name-plugin-notification = %version-%release
Requires:	%name-plugin-pdfviewer = %version-%release
Requires:	%name-plugin-perl = %version-%release
Requires:	%name-plugin-pgpcore = %version-%release
Requires:	%name-plugin-pgpinline = %version-%release
Requires:	%name-plugin-pgpmime = %version-%release
%if_enabled python
Requires:	%name-plugin-python = %version-%release
%endif
Requires:	%name-plugin-rssyl = %version-%release
Requires:	%name-plugin-smime = %version-%release
Requires:	%name-plugin-spamassassin = %version-%release
Requires:	%name-plugin-spamreport = %version-%release
%if_enabled tnef
Requires:	%name-plugin-tnef = %version-%release
%endif
Requires:	%name-plugin-vcalendar = %version-%release

%description	plugins
This virtual package installs all plugins for %name.

%package	plugin-acpinotifier
Summary:	Mail notification via LEDs on some laptops (Acer, ASUS, Fujitsu, IBM).
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-acpinotifier
The AcpiNotifier plugin handles the email LED found on some laptops.
It makes it possible to see whether you have new emails from the other
side of the room, without even unlocking the screen. The plugin handles
the following types of laptops:

 * ACER,
 * ASUS,
 * IBM,
 * Fujitsu,
 and others.

%package	plugin-addresskeeper
Summary:	Keeps all recipient addresses in an addressbook folder
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-addresskeeper
This plugin allows saving outgoing addresses to a designated folder
in the address book. Addresses are saved only if not found in the
address book to avoid unwanted duplicates.
Selecting which headers are scanned for keeping addresses is also
supported (Any or several of 'To', 'Cc' or 'Bcc').

%package	plugin-archive
Summary:	Mail archiving functionality for Claws Mail
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-archive
This plugin adds archiving features to Claws Mail.

%package	plugin-attachwarner
Summary:	Warn when the user is likely to have forgotten to attach a file.
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-attachwarner
The AttachWarner verifies that you have attached something to your email
if you mentioned attachment in the email's body.

%package	plugin-attremover
Summary:	This plugin lets you remove attachments from emails
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-attremover
This plugin lets you remove attachments from emails.

%package	plugin-bogofilter
Summary:	Bogofilter plugin for %name
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	bogofilter bogofilter-utils
Obsoletes:	%_oldname-plugin-bogofilter < %version
Provides:	%_oldname-plugin-bogofilter

%description	plugin-bogofilter
This plugin for %name provides integration with Bogofilter spam checking
tool.

%package	plugin-bsfilter
Summary:	Check messages for spam using Bsfilter
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	bsfilter

%description	plugin-bsfilter
Check all messages that are received from an IMAP, LOCAL or POP account
for spam using Bsfilter.

%package	plugin-clamd
Summary:	This plugin scans messages using clamd (Clam AV)
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	clamav

%description	plugin-clamd
This plugin scans all messages that are received from an IMAP, LOCAL or
POP account using clamd (Clam AV).

%package       plugin-dillo
Summary:       Dillo browser plugin for %name
Group:         Networking/Mail
Requires:      %name = %version
Requires:      dillo >= 0.7.2
Obsoletes:     %_oldname-plugin-dillo < %version
Provides:      %_oldname-plugin-dillo

%description   plugin-dillo
This plugin uses the Dillo (http://www.dillo.org) browser to
view text/html MIME parts inside Claws Mail.
See README file for more information.

This plugin only provides very basic HTML
support; if you want something more, consider installing
%name-plugin-fancy package.

%package	plugin-fancy
Summary:	Renders HTML e-mail using the WebKit library
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-fancy
The Fancy plugin renders html email using the GTK+ port of WebKit
library.

%package	plugin-fetchinfo
Summary:	This plugin inserts headers containing some download information
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-fetchinfo
This plugin inserts headers containing some download information: UIDL,
Claws' account name, POP server, user ID and retrieval time.

%package	plugin-keywordwarner
Summary:	Warn when message text contains a keyword
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-keywordwarner
This plugin shows a warning when sending or queueing a message and a reference
to one or more keywords is found in the message text.

%package	plugin-libravatar
Summary:	Pligin displays libravatar/gravatar profiles' images
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-libravatar
This plugin allows showing the profile picture associated to email
addresses provided by https://www.libravatar.org/. You can read
more about what is this at http://wiki.libravatar.org/description/.
By default missing profiles in the libravatar site are also searched
in http://gravatar.com, so it will also show pictures from gravatar
profiles.

%package	plugin-litehtmlviewer
Summary:	Viewer plugin for HTML emails, using the litehtml library
Group:		Networking/Mail
License:	GPLv3+ and BSD-3-Clause
Requires:	%name = %version-%release

%description	plugin-litehtmlviewer
Viewer plugin for HTML emails, using the litehtml library
(http://www.litehtml.com/).

%package	plugin-mailmbox
Summary:	This plugin handles mailboxes in mbox format
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-mailmbox
This plugin handles mailboxes in mbox format.

%package	plugin-managesieve
Summary:	This plugin handles managing Sieve filters
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-managesieve
The Claws Mail ManageSieve plugin provides an interface for managing
Sieve filters. Sieve filters are used for filtering mail on mail
servers, usually with an IMAP account.

This plugin handles managing Sieve filters, editing them, and checking
their syntax.

To learn how to write Sieve filters, see RFC 5228
https://tools.ietf.org/html/rfc5228
and the Sieve language extensions
http://sieve.info/documents#sieve_language_extensions

%package	plugin-newmail
Summary:	This plugin writes a msg header summary to a log file
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-newmail
This plugin writes a msg header summary to a log file,
(Default: ~/Mail/NewLog), on arrival of new mail *after* sorting.

%package	plugin-notification
Summary:	Various ways to notify the user of new and unread email
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-notification
The Notification plugin provides various ways to notify the user of new
and possibly unread mail. Currently, the following modules are
implemented:

    * A mail banner (stocks ticker-like widget)
    * A popup window
    * A command to be issued on new mail arrival

All modules can be activated or deactivated at compilation time, and are
highly configurable at run time. It is possible to include only selected
folders in any module. In general, the notification is executed after
filtering, so it is possible to exclude spam or other unwanted messages
from notification.

%package	plugin-pdfviewer
Summary:	This plugin enables the viewing of PDF and PostScript attachments
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-pdfviewer
The PDF Viewer plugin renders PDF and Postscript attachments in Claws
Mail. It features:

  * Moving between document pages, sequentially and jumping to
    a specific page
  * Zoom, Rotation, Fit Page, Fit Page Width
  * Displaying information about the document such as Author, Date,
    Creator, etc...
  * Displaying the PDF Index, if available, which allows easily surfing
    the document
  * Search text inside the document
  * Manage links to internal and external documents, if available, such
    as jumping to the paragraph or section and also opening an external
    URL or composing a new mail

The Poppler library and GhostScript are required.

%package	plugin-perl
Summary:	This plugin provides a Perl interface to Claws Mail' filtering mechanism
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	perl

%description	plugin-perl
This plugin is intended to extend the filtering possibilities of Claws
Mail. It provides a Perl interface to Claws Mail' filtering mechanism,
allowing the use of full Perl power in email filters.

%package	plugin-pgpcore
Summary:	Core PGP plugin for %name
Group:		Networking/Mail
Requires:	%name = %version-%release
Obsoletes:	%_oldname-plugin-pgpcore < %version
Provides:	%_oldname-plugin-pgpcore

%description	plugin-pgpcore
This plugin for %name provides core PGP functionality. It is used by
other encryption/signing plugins.

%package	plugin-pgpinline
Summary:	PGP/Inline plugin for %name
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	%name-plugin-pgpcore = %version-%release
Obsoletes:	%_oldname-plugin-pgpinline < %version
Provides:	%_oldname-plugin-pgpinline

%description	plugin-pgpinline
This plugin for %name lets you create and see messages encrypted/signed
with PGP/Inline.

%package	plugin-pgpmime
Summary:	PGP/MIME plugin for %name
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	%name-plugin-pgpcore = %version-%release
Obsoletes:	%_oldname-plugin-pgpmime < %version
Provides:	%_oldname-plugin-pgpmime

%description	plugin-pgpmime
This plugin for %name lets you create and see messages encrypted/signed
with PGP/MIME.

%package	plugin-python
Summary:	This plugin provides Python integration features
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	python

%description	plugin-python
This plugin offers Python scripting access to Claws Mail.
Python code can be entered interactively into an embedded Python
console, or stored in scripts.

%package	plugin-rssyl
Summary:	RSS feed aggregator for Claws Mail
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-rssyl
he RSSyl plugin is an RSS feed aggregator for Claws Mail. It has the
following features:

    * Handling of RSS 1.0, RSS 2.0, and Atom feeds
    * Fetching and threaded display of comment feeds
    * Customisable refresh interval for each feed
    * Customisable number of feed items to keep for each feed

Navigating in your feeds and posts is done in the same way as you would
for emails, which makes feed-reading really fast and enjoyable if Claws
Mail's shortcuts are hardwired into your fingers.
Also, the RSSyl plugin unleashes its full potential when used with an
HTML viewer plugin like Dillo or Gtkhtml2Viewer, as this allows fetching
a post's images and font styles.

%package	plugin-smime
Summary:	S/MIME plugin for %name
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	%name-plugin-pgpcore = %version-%release
Requires:   dirmngr gnupg2-common
Obsoletes:	%_oldname-plugin-smime < %version
Provides:	%_oldname-plugin-smime

%description	plugin-smime
This plugin for %name lets you create and see messages encrypted/signed
with S/MIME.

%package	plugin-spamassassin
Summary:	SpamAssassin plugin for %name
Group:		Networking/Mail
Requires:	%name = %version-%release
Requires:	spamassassin
Obsoletes:	%_oldname-plugin-spamassassin < %version
Provides:	%_oldname-plugin-spamassassin

%description	plugin-spamassassin
This plugin for %name provides integration with SpamAssassin.

%package	plugin-spamreport
Summary:	This plugin reports spam to various places
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-spamreport
This Claws Mail plugin allows you to upload your spams to various spam
reporting places, like http://www.signal-spam.fr/ or http://www.spamcop.net/.

%package	plugin-tnef
Summary:	This plugin enables reading application/ms-tnef attachments
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-tnef
The TNEF Parser plugins handles TNEF attachments from Outlook.
TNEF attachments have a MIME type of "application/ms-tnef" and
are often named "winmail.dat". They can contain multiple files.
This plugin parses this kind of attachment and displays the real files
in the parts list.

%package	plugin-vcalendar
Summary:	Plugin handles the vCalendar for Claws Mail
Group:		Networking/Mail
Requires:	%name = %version-%release

%description	plugin-vcalendar
This Claws Mail plugin handles the vCalendar format (or rather, the
meeting subset of it). It displays such mails in a nice format, lets you
create and send meetings, and creates a virtual folder with the meetings
you sent or received.

%package	tools
Summary:	Additional tools for %name
Group:		Networking/Mail
Requires:	%name = %version-%release

BuildArch: noarch

Obsoletes:	%_oldname-tools < %version
Provides:	%_oldname-tools

%description	tools
additional tools for %name.

%prep
%setup

subst "s,%%f,%%N," ./src/prefs_quote.c
echo "Libs: -lenchant-2 -lgnutls" >>%name.pc.in

# set version
echo 'echo "%version"' >./version

%patch -p1

%autoreconf

%build
%add_optflags -fpie
export LDFLAGS=-pie
%configure \
		--disable-static \
		--disable-rpath \
		--with-lib-prefix=%_usr \
		--with-manualdir=%_defaultdocdir/%name \
		--with-config-dir=.%name \
		%{subst_enable manual} \
		--disable-jpilot \
		%{subst_enable appdata} \
		%{subst_enable svg} \
		%{subst_enable networkmanager} \
		%if_disabled archive
		--disable-archive-plugin \
		%endif
		%if_disabled bsfilter
		--disable-bsfilter-plugin \
		%endif
		%if_disabled dillo
		--disable-dillo-plugin \
		%endif
		%if_disabled fancy
		--disable-fancy-plugin \
		%endif
		%if_disabled litehtmlviewer
		--disable-litehtml_viewer-plugin \
		%else
		--enable-litehtml_viewer-plugin \
		%endif
		%if_disabled python
		--disable-python-plugin \
		%endif
		%if_disabled tnef
		--disable-tnef_parse-plugin \
		%endif
		%if_enabled debug
		--enable-crash-dialog
		%else
		--disable-crash-dialog
		%endif
%make_build
%make -C tools

%install
%makeinstall_std
%make -C tools install

mkdir -p %buildroot%_datadir/%name/
cp -va  tools %buildroot%_datadir/%name/
rm -vf  %buildroot%_datadir/%name/tools/README*
rm -vf  %buildroot%_datadir/%name/tools/Makefile*

mkdir -p %buildroot%_pixmapsdir
install -p -m644 %name.png %buildroot%_pixmapsdir/

# XXX: Make sure the path below is the same as the path above.
%define _claws_plugins_path %_libdir/%name/plugins

%if_enabled litehtmlviewer
# Install litehtml BSD 3-clause license
mkdir -p %buildroot%_defaultdocdir/%name-plugin-litehtmlviewer-%version/litehtml/
install -p -m644 src/plugins/litehtml_viewer/litehtml/LICENSE %buildroot%_defaultdocdir/%name-plugin-litehtmlviewer-%version/litehtml/
%endif

%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog* COPYING INSTALL NEWS README* RELEASE_NOTES
%_bindir/%name
%_man1dir/%name.1.*
%_desktopdir/*.desktop
%if_enabled appdata
%_datadir/appdata/claws-mail.appdata.xml
%endif
%_iconsdir/hicolor/*x*/apps/%name.png
%_pixmapsdir/%name.png
%dir %_libdir/%name
%dir %_claws_plugins_path
%dir %_datadir/%name
%if_enabled manual
%_defaultdocdir/%name/
%exclude %_defaultdocdir/%name/RELEASE_NOTES
%endif

%files devel
%_includedir/%name
%_pkgconfigdir/%name.pc

%files plugins

%files plugin-acpinotifier
%_claws_plugins_path/acpi_notifier.so
%if_enabled appdata
%_datadir/appdata/claws-mail-acpi_notifier.metainfo.xml
%endif

%files plugin-addresskeeper
%_claws_plugins_path/address_keeper.so
%if_enabled appdata
%_datadir/appdata/claws-mail-address_keeper.metainfo.xml
%endif

%if_enabled archive
%files plugin-archive
%_claws_plugins_path/archive.so
%if_enabled appdata
%_datadir/appdata/claws-mail-archive.metainfo.xml
%endif
%endif

%files plugin-attachwarner
%_claws_plugins_path/attachwarner.so
%if_enabled appdata
%_datadir/appdata/claws-mail-attachwarner.metainfo.xml
%endif

%files plugin-attremover
%_claws_plugins_path/att_remover.so
%if_enabled appdata
%_datadir/appdata/claws-mail-att_remover.metainfo.xml
%endif

%files plugin-bogofilter
%_claws_plugins_path/bogofilter.so
%if_enabled appdata
%_datadir/appdata/claws-mail-bogofilter.metainfo.xml
%endif

%if_enabled bsfilter
%files plugin-bsfilter
%_claws_plugins_path/bsfilter.so
%if_enabled appdata
%_datadir/appdata/claws-mail-bsfilter.metainfo.xml
%endif
%endif

%files plugin-clamd
%_claws_plugins_path/clamd.so
%if_enabled appdata
%_datadir/appdata/claws-mail-clamd.metainfo.xml
%endif

%if_enabled dillo
%files plugin-dillo
%_claws_plugins_path/dillo.so
%if_enabled appdata
%_datadir/appdata/claws-mail-dillo.metainfo.xml
%endif
%endif

%if_enabled fancy
%files plugin-fancy
%_claws_plugins_path/fancy.so
%if_enabled appdata
%_datadir/appdata/claws-mail-fancy.metainfo.xml
%endif
%endif

%files plugin-fetchinfo
%_claws_plugins_path/fetchinfo.so
%if_enabled appdata
%_datadir/appdata/claws-mail-fetchinfo.metainfo.xml
%endif

%files plugin-keywordwarner
%_claws_plugins_path/keyword_warner.so

%files plugin-libravatar
%doc src/plugins/libravatar/README*
%_claws_plugins_path/libravatar.so
%if_enabled appdata
%_datadir/appdata/claws-mail-libravatar.metainfo.xml
%endif

%if_enabled litehtmlviewer
%files plugin-litehtmlviewer
%doc %_defaultdocdir/%name-plugin-litehtmlviewer-%version/
%_claws_plugins_path/litehtml_viewer.so
%endif

%files plugin-mailmbox
%_claws_plugins_path/mailmbox.so
%if_enabled appdata
%_datadir/appdata/claws-mail-mailmbox.metainfo.xml
%endif

%files plugin-managesieve
%_claws_plugins_path/managesieve.so
%if_enabled appdata
%_datadir/appdata/claws-mail-managesieve.metainfo.xml
%endif

%files plugin-newmail
%_claws_plugins_path/newmail.so
%if_enabled appdata
%_datadir/appdata/claws-mail-newmail.metainfo.xml
%endif

%files plugin-notification
%_claws_plugins_path/notification.so
%if_enabled appdata
%_datadir/appdata/claws-mail-notification.metainfo.xml
%endif

%files plugin-pdfviewer
%_claws_plugins_path/pdf_viewer.so
%if_enabled appdata
%_datadir/appdata/claws-mail-pdf_viewer.metainfo.xml
%endif

%files plugin-perl
%_claws_plugins_path/perl.so
%if_enabled appdata
%_datadir/appdata/claws-mail-perl.metainfo.xml
%endif

%files plugin-pgpcore
%_claws_plugins_path/pgpcore.so
%if_enabled appdata
%_datadir/appdata/claws-mail-pgpcore.metainfo.xml
%endif

%files plugin-pgpinline
%_claws_plugins_path/pgpinline.so
%_claws_plugins_path/pgpinline.deps
%if_enabled appdata
%_datadir/appdata/claws-mail-pgpinline.metainfo.xml
%endif

%files plugin-pgpmime
%_claws_plugins_path/pgpmime.so
%_claws_plugins_path/pgpmime.deps
%if_enabled appdata
%_datadir/appdata/claws-mail-pgpmime.metainfo.xml
%endif

%if_enabled python
%files plugin-python
%_claws_plugins_path/python.so
%if_enabled appdata
%_datadir/appdata/claws-mail-python.metainfo.xml
%endif
%endif

%files plugin-rssyl
%_claws_plugins_path/rssyl.so
%if_enabled appdata
%_datadir/appdata/claws-mail-rssyl.metainfo.xml
%endif

%files plugin-smime
%_claws_plugins_path/smime.so
%_claws_plugins_path/smime.deps
%if_enabled appdata
%_datadir/appdata/claws-mail-smime.metainfo.xml
%endif

%files plugin-spamassassin
%doc src/plugins/spamassassin/README* src/plugins/spamassassin/NOTICE
%_claws_plugins_path/spamassassin.so
%if_enabled appdata
%_datadir/appdata/claws-mail-spamassassin.metainfo.xml
%endif

%files plugin-spamreport
%_claws_plugins_path/spamreport.so
%if_enabled appdata
%_datadir/appdata/claws-mail-spam_report.metainfo.xml
%endif

%if_enabled tnef
%files plugin-tnef
%_claws_plugins_path/tnef_parse.so
%if_enabled appdata
%_datadir/appdata/claws-mail-tnef_parse.metainfo.xml
%endif
%endif

%files plugin-vcalendar
%_claws_plugins_path/vcalendar.so
%if_enabled appdata
%_datadir/appdata/claws-mail-vcalendar.metainfo.xml
%endif

%files tools
%doc tools/README*
%_datadir/%name/tools/
%exclude %_datadir/%name/tools/update-po
%exclude %_datadir/%name/tools/check-appstream.sh
%exclude %_datadir/%name/tools/gitlog2changelog.py

%exclude %_claws_plugins_path/*.la
%exclude %_datadir/doc/%name/RELEASE_NOTES

%changelog
