%define build_type RelWithDebInfo
%define builddir %_cmake__builddir
%define _cmake %cmake -G Ninja -S . -Wno-dev -DCMAKE_C_COMPILER=clang -DCMAKE_CXX_COMPILER=clang++ -DCMAKE_BUILD_TYPE=%build_type -DCMAKE_STRIP:STRING=""
%define _ninja_build ninja -vvv -j %__nprocs -C %builddir
%define optflags_lto %nil
%define bits 64
# HIP requires some components which are not built
# yet to ALT (cuda as example)
%def_with HIP

Name: clr
Version: 5.7.0
Release: alt0.p10.1
License: MIT
Summary: Radeon Open Compute Common Language Runtime
Url: https://github.com/ROCm-Developer-Tools/clr
Group: System/Libraries

Source0: %name-%version.tar
# https://github.com/ROCm-Developer-Tools/HIP.git
Source1: hip.tar
# https://github.com/ROCm-Developer-Tools/HIPCC.git
Source2: hipcc.tar
# sane defaults for HIP
Source4: hip.sh

Patch0: hipcc-alt-paths.patch
Patch1: rocclr-gcc-13-fixes.patch
Patch2: opencl-gcc-13-fixes.patch
Patch3: hipcc-alt-hardcore-llvm-rocm.patch
Patch4: clr-alt-cltrace-link-pthread.patch
# patches from developer branch

BuildRequires(pre): cmake /proc ninja-build
BuildRequires: llvm-rocm-devel = %version clang-rocm-devel = %version clang-rocm-tools = %version
BuildRequires: zlib-devel libstdc++-devel rocm-cmake = %version rocm-comgr-devel = %version hsa-rocr-devel = %version
BuildRequires: libX11-devel libnuma-devel libGL-devel
BuildRequires: lld-rocm
%if_with HIP
BuildRequires: python3-module-CppHeaderParser
%endif

ExclusiveArch: x86_64

%description
ROCclr is a virtual device interface that compute runtimes interact with to
different backends such as ROCr or PAL This abstraction allows runtimes to work
on Windows as well as on Linux without much effort.

%package -n rocm-opencl-runtime
Summary: ROCm OpenCL Compatible Runtime
Group: System/Libraries
Requires: opencl-filesystem

%description -n rocm-opencl-runtime
ROCm OpenCL Compatible Runtime:

- OpenCL 2.0 compatible language runtime
- Supports offline and in-process/in-memory compilation

%package -n hip-devel
Summary: HIP:Heterogenous-computing Interface for Portability
Group: Development/Other
# as hip scripts are noarch
# perl scripts rely on runtime envs
AutoReq: yes, noperl
Requires: clang-rocm = %version clang-rocm-tools = %version clang-rocm-libs-support = %version llvm-rocm = %version lld-rocm = %version glibc-devel gcc
Requires: rocm-device-libs = %version rocminfo = %version hip-runtime-amd = %EVR

%description -n hip-devel
HIP: Heterogenous-computing Interface for Portability development libraries and
headers.

%package -n hip-runtime-amd
Summary: HIP implementation specifically for AMD platform.
Group: Development/Other

%description -n hip-runtime-amd
HIP is a C++ Runtime API and Kernel Language that allows developers to create
portable applications for AMD and NVIDIA GPUs from single source code.

This package provides the HIP implementation specifically for AMD platform.

%prep
%setup -n %name-%version -a1 -a2
%autopatch -p1

%build
export ALTWRAP_LLVM_VERSION=rocm
%_cmake \
    -DUSE_COMGR_LIBRARY=ON \
    -DCMAKE_INSTALL_LIBDIR=%_lib \
    -DFILE_REORG_BACKWARD_COMPATIBILITY=OFF \
    -DCMAKE_PREFIX_PATH="../../" \
    -DCLR_BUILD_OCL=ON \
    -DBUILD_ICD:BOOL=TRUE \
%if_with HIP
    -DHIP_OFFICIAL_BUILD=ON \
    -DCLR_BUILD_HIP=ON \
    -DHIPCC_BIN_DIR=%_builddir/%name-%version/hipcc/bin \
    -DHIP_COMMON_DIR=%_builddir/%name-%version/hip \
    -DCMAKE_MODULE_PATH=%_libdir/cmake \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DHIP_PLATFORM=amd \
%endif
    %nil
%_ninja_build

%install
%cmake_install
install -pD -m644 opencl/config/amdocl%{bits}.icd %buildroot%_sysconfdir/OpenCL/vendors/amdocl%{bits}.icd
# rocm clinfo expose more information than third-party clinfo
mv %buildroot%_bindir/clinfo %buildroot%_bindir/rocm-clinfo

%if_with HIP
# hip cmake scripts are noarch
mkdir -p %buildroot%_datadir/cmake/hip
mv %buildroot%_libdir/cmake/hip/FindHIP.cmake %buildroot%_datadir/cmake/hip/
mv %buildroot%_libdir/cmake/hip/FindHIP %buildroot%_datadir/cmake/hip

mkdir -p %buildroot%_sysconfdir/profile.d
install -p -m 755 %SOURCE4 %buildroot%_sysconfdir/profile.d/
%endif

%files -n rocm-opencl-runtime
%_bindir/rocm-clinfo
%_libdir/libamdocl%{bits}.so
%_libdir/libcltrace.so
%_sysconfdir/OpenCL/vendors/amdocl%{bits}.icd

%if_with HIP
%files -n hip-devel
%doc hip/README.md hip/RELEASE.md hip/LICENSE.txt
%_sysconfdir/profile.d/hip.sh
%_bindir/*
%exclude %_bindir/rocm-clinfo
%_includedir/hip
%_includedir/hip_prof_str.h
%_datadir/cmake/hip
%_datadir/hip

%files -n hip-runtime-amd
%doc hipamd/README.md hipamd/LICENSE.txt
%_libdir/cmake/hip
%_libdir/cmake/hip-lang
%_libdir/cmake/hiprtc
%_libdir/libamdhip%{bits}*.so*
%_libdir/libhiprtc-builtins*.so*
%_libdir/libhiprtc*.so*
%endif

%changelog
