%def_disable snapshot
%define ver_major 1.26

%def_enable x11_backend
%def_enable gdk_backend
%def_enable egl_backend
%def_disable tslib_input
%def_enable evdev_input
%def_enable xinput
%def_enable gdk_pixbuf
%def_enable installed_tests
%def_enable gtk_doc

# libcogl compiled with --enable-wayland-egl-platform required
%def_enable wayland_backend
# libcogl compiled with --enable-wayland-egl-server required
%def_enable wayland_compositor

Name: clutter
Version: %ver_major.4
Release: alt1

Summary: Clutter Core Library
License: LGPLv2+
Group: System/Libraries
Url: http://www.clutter-project.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.54
%define cogl_ver 1.22.6
%define json_glib_ver 0.12.0
%define atk_ver 2.5.3
%define cairo_ver 1.14
%define pango_ver 1.30
%define gi_version 1.40
%define uprof_ver 0.3
%define gtk_doc_ver 1.20
%define xfixes_ver 3
%define xcomposite_ver 0.4
%define gdk_ver 3.22.6
%define libinput_ver 0.19

BuildRequires: libGL-devel
BuildRequires: pkgconfig(cogl-1.0) >= %cogl_ver pkgconfig(cairo-gobject) >= %cairo_ver pkgconfig(atk) >= %atk_ver pkgconfig(pangocairo) >= %pango_ver pkgconfig(cogl-pango-1.0) pkgconfig(json-glib-1.0) >= %json_glib_ver
BuildRequires: gtk-doc >= %gtk_doc_ver
BuildRequires: gobject-introspection-devel gir(GL) = 1.0 gir(GObject) = 2.0 gir(cairo) = 1.0 libcogl-gir-devel gir(Atk) = 1.0 gir(Json) = 1.0
%{?_enable_x11_backend:BuildRequires: pkgconfig(pangoft2) pkgconfig(x11) pkgconfig(xext) pkgconfig(xfixes) >= %xfixes_ver pkgconfig(xdamage) pkgconfig(xcomposite) >= %xcomposite_ver }
%{?_enable_wayland_backend:BuildRequires: pkgconfig(wayland-client) pkgconfig(wayland-cursor) pkgconfig(xkbcommon) pkgconfig(gdk-pixbuf-2.0)}
%{?_enable_wayland_compositor:BuildRequires: pkgconfig(wayland-server)}
%{?_enable_gdk_backend:BuildRequires: pkgconfig(gdk-3.0) >= %gdk_ver gir(Gdk) = 3.0}
%{?_enable_tslib_input:BuildRequires: pkgconfig(tslib-1.0)}
%{?_enable_evdev_input:BuildRequires: pkgconfig(gudev-1.0) pkgconfig(xkbcommon) pkgconfig(libevdev) libinput-devel >= %libinput_ver}
%{?_enable_xinput:BuildRequires: pkgconfig(xi)}
%{?_enable_gdk_pixbuf:BuildRequires: pkgconfig(gdk-pixbuf-2.0)}

%description
Clutter is an open source software library for creating fast, visually
rich graphical user interfaces. The most obvious example of potential
usage is in media center type applications. We hope however it can be
used for a lot more.

Clutter uses OpenGL (and soon optionally OpenGL ES) for rendering but
with an API which hides the underlying GL complexity from the
developer. The Clutter API is intended to be easy to use, efficient
and flexible.

%package -n lib%name
Summary: Clutter Core Library
Group: System/Libraries

%description -n lib%name
Clutter is an open source software library for creating fast, visually
rich graphical user interfaces. The most obvious example of potential
usage is in media center type applications. We hope however it can be
used for a lot more.

Clutter uses OpenGL (and soon optionally OpenGL ES) for rendering but
with an API which hides the underlying GL complexity from the
developer. The Clutter API is intended to be easy to use, efficient
and flexible.

%package -n lib%name-devel
Summary: Header files for clutter library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Header files for clutter library.

%package -n lib%name-gir
Summary: GObject introspection data for the clutter library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the clutter library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the clutter library
Group: System/Libraries
BuildArch: noarch
Requires: libcogl-gir-devel
Requires: lib%name-gir = %version-%release lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the clutter library

%package -n lib%name-devel-doc
Summary: Development package for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description  -n lib%name-devel-doc
Contains developer documentation for %name.

%package -n lib%name-tests
Summary: Tests for the lib%name package
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-tests
This package provides tests programs that can be used to verify
the functionality of the installed lib%name package.


%prep
%setup

%build
gtkdocize
%autoreconf
%configure \
	--disable-static \
	%{?_enable_x11_backend:--enable-x11-backend} \
	%{?_enable_gdk_backend:--enable-gdk-backend} \
	%{?_enable_wayland_backend:--enable-wayland_backend} \
	%{?_enable_wayland_compositor:--enable-wayland-compositor} \
	%{?_enable_egl_backend:--enable-egl-backend} \
	%{?_enable_tslib_input:--enable-tslib-input} \
	%{?_enable_xinput:--enable-xinput} \
	%{?_enable_evdev_input:--enable-evdev-input} \
	%{?_enable_gdk_pixbuf:--enable-gdk-pixbuf} \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--enable-introspection \
	%{?_enable_installed_tests:--enable-installed-tests}

%make_build

%install
%makeinstall_std
%find_lang clutter-1.0

%check
#%%make check

%files -n lib%name -f clutter-1.0.lang
%doc NEWS README*
%_libdir/lib%name-*.so.*

%files -n lib%name-devel
%_includedir/%name-*
%_libdir/lib%name-*.so
%_pkgconfigdir/*.pc

%files -n lib%name-gir
%_libdir/girepository-1.0/*.typelib

%files -n lib%name-gir-devel
%_datadir/gir-1.0/*.gir

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled installed_tests
%files -n lib%name-tests
%_libexecdir/installed-tests/%name/
%_datadir/installed-tests/%name/
%endif

%exclude %_datadir/%name-1.0/valgrind


%changelog
