%def_disable snapshot

%def_enable daemon
%def_enable session_helper
%def_enable reverse
%def_enable introspection
%def_enable vala
%def_enable bash_completion
%def_enable installed_tests
%def_enable libcolordcompat
%def_enable systemd

# ArgyllCMS required fot build
%def_disable argyllcms_sensor
%def_disable print_profiles

%def_enable docs
%def_disable check

%ifarch %valgrind_arches
%def_enable valgrind
%endif

%define _libexecdir %_prefix/libexec
%define _icccolordir %_datadir/color/icc
%define _localstatedir %_var

Name: colord
Version: 1.4.6
Release: alt1

Summary: Color daemon
License: GPLv2+
Group: Graphics
Url: http://colord.hughsie.com

%if_disabled snapshot
Source: http://www.freedesktop.org/software/%name/releases/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define colord_group %name
%define colord_user %name
%define glib_ver 2.58
%define polkit_ver 0.113-alt2
%define lcms_ver 2.6
%define gusb_ver 0.2.7
%define bash_completion_ver 2.0

Requires: lib%name = %version-%release

BuildRequires(pre): meson
BuildRequires(pre): rpm-macros-valgrind
BuildRequires: /proc glib2-devel >= %glib_ver
BuildRequires: docbook-utils docbook5-style-xsl gtk-doc
BuildRequires: libdbus-devel libgudev-devel libudev-devel
BuildRequires: liblcms2-devel >= %lcms_ver libpolkit-devel >= %polkit_ver
BuildRequires: libsqlite3-devel libusb-devel libgusb-devel >= %gusb_ver
%{?_enable_systemd:BuildRequires: pkgconfig(systemd)}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgusb-gir-devel}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_argyllcms_sensor:BuildRequires: argyllcms}
%{?_enable_print_profiles:BuildRequires: argyllcms}
%{?_enable_bash_completion:BuildRequires: bash-completion > %bash_completion_ver}
%{?_enable_check:BuildRequires: /proc dbus-tools-gui}
%{?_enable_valgrind:BuildRequires: valgrind-tool-devel}

%description
colord is a low level system activated daemon that maps color devices to color
profiles in the system context.

%package -n lib%name
Summary: Colord shared library
Group: System/Libraries

%description -n lib%name
This package provides shared library for Colord to work.

%package -n lib%name-devel
Summary: Development package for %name
Group: Development/C
Obsoletes: %name-devel
Provides: %name-devel = %version-%release
Requires: lib%name = %version-%release

%description -n lib%name-devel
colord is a low level system activated daemon that maps color devices to color
profiles in the system context.

This package provides development files for Colord library.

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name
Group: Development/Other
BuildArch: noarch
Requires: lib%name-devel = %version-%release
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library

%package -n lib%name-vala
Summary: Vala Bindings for lib%name
Group: Development/C
BuildArch: noarch
Requires: lib%name = %version-%release

%description -n lib%name-vala
This package provides Vala language bindings for %name library

%package extra-profiles
Summary: Color profiles for color management that are less commonly used
Group: Graphics
Requires: %name = %version-%release
BuildArch: noarch

%description extra-profiles
More color profiles for color management that are less commonly used.
This may be useful for CMYK soft-proofing or for extra device support.

%package tests
Summary: Tests for the Colord
Group: Development/Other
Requires: lib%name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Golord.

%package devel-doc
Summary: Development documentation for Colord
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides Colord reference manual

%prep
%setup

%build
%meson \
	%{?_disable_reverse:-Denable-reverse=false} \
	%{?_enable_vala:-Dvapi=true} \
	-Ddaemon_user=%colord_user \
	%{?_disable_argyllcms_sensor=-Dargyllcms_sensor=false} \
	%{?_enable_print_profiles:-Dprint_profiles=true} \
	%{?_disable_bash_completion:-Dbash_completion=false} \
	%{?_enable_installed_tests:-Dinstalled_tests=true} \
	%{?_enable_libcolordcompat:-Dlibcolordcompat=true} \
	%{?_disable_systemd:-Dsystemd=false} \
	%{?_disable_docs:-Ddocs=false}
%meson_build

%install
%meson_install

mkdir -p %buildroot%_localstatedir/lib/{%name,color}/icc

# databases
touch %buildroot%_localstatedir/lib/%name/mapping.db
touch %buildroot%_localstatedir/lib/%name/storage.db

%find_lang %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%pre
%_sbindir/groupadd -r -f %colord_group 2>/dev/null ||:
%_sbindir/useradd -r -n -g %colord_group -d %_localstatedir/%name \
	-s /dev/null -c "User for colord" %colord_user 2>/dev/null ||:

%files -f %name.lang
%_bindir/*
%_datadir/glib-2.0/schemas/org.freedesktop.ColorHelper.gschema.xml
%_libexecdir/%name
%_libexecdir/colord-session
%_datadir/dbus-1/system.d/org.freedesktop.ColorManager.conf
%_datadir/dbus-1/interfaces/org.freedesktop.ColorManager*.xml
%_datadir/dbus-1/system-services/org.freedesktop.ColorManager.service
%_datadir/polkit-1/actions/org.freedesktop.color.policy
/lib/udev/rules.d/*.rules
%_tmpfilesdir/%name.conf

%if_enabled session_helper
%_datadir/dbus-1/interfaces/org.freedesktop.ColorHelper.xml
%_datadir/dbus-1/services/org.freedesktop.ColorHelper.service
%_prefix/lib/systemd/user/%name-session.service
%endif

%dir %_libdir/colord-sensors
%_libdir/colord-sensors/libcolord_sensor_dummy.so
%_libdir/colord-sensors/libcolord_sensor_huey.so
%_libdir/colord-sensors/libcolord_sensor_colorhug.so
%_libdir/colord-sensors/libcolord_sensor_argyll.so
%_libdir/colord-sensors/libcolord_sensor_dtp94.so

%dir %_libdir/colord-plugins
%_libdir/colord-plugins/libcolord_sensor_camera.so
%_libdir/colord-plugins/libcolord_sensor_scanner.so
%_datadir/%name/
%_man1dir/cd-create-profile.1.*
%_man1dir/colormgr.*
%_man1dir/cd-fix-profile.*
%_man1dir/cd-it8.1.*
%attr(755,%colord_user,%colord_group) %dir %_localstatedir/lib/%name
%attr(755,%colord_user,%colord_group) %dir %_localstatedir/lib/%name/icc
%dir %_localstatedir/lib/color
%dir %_localstatedir/lib/color/icc
%ghost %_localstatedir/lib/%name/*.db
%systemd_unitdir/*.service
%{?_enable_bash_completion:%_datadir/bash-completion/completions/colormgr}

# common colorspaces from shared-color-profiles
%dir %_icccolordir/colord
%_icccolordir/colord/AdobeRGB1998.icc
%_icccolordir/colord/AppleRGB.icc
%_icccolordir/colord/CIE-RGB.icc
%_icccolordir/colord/ColorMatchRGB.icc
%_icccolordir/colord/NTSC-RGB.icc
%_icccolordir/colord/PAL-RGB.icc
%_icccolordir/colord/ProPhotoRGB.icc
%_icccolordir/colord/Rec709.icc
%_icccolordir/colord/SMPTE-C-RGB.icc
%_icccolordir/colord/sRGB.icc

# so we can display at least something in the default dropdown
%if_enabled print_profiles
%_icccolordir/colord/FOGRA39L_coated.icc
%endif

# monitor test profiles
%_icccolordir/colord/Bluish.icc
%_icccolordir/colord/SwappedRedAndGreen.icc
%_icccolordir/colord/Gamma*.icc

# named color profiles
%_icccolordir/colord/x11-colors.icc

%files extra-profiles
%if_enabled print_profiles
%_icccolordir/colord/FOGRA27L_coated.icc
%_icccolordir/colord/FOGRA28L_webcoated.icc
%_icccolordir/colord/FOGRA29L_uncoated.icc
%_icccolordir/colord/FOGRA30L_uncoated_yellowish.icc
%_icccolordir/colord/FOGRA40L_SC_paper.icc
%_icccolordir/colord/FOGRA45L_lwc.icc
%_icccolordir/colord/FOGRA47L_uncoated.icc
%_icccolordir/colord/GRACoL*.icc
%_icccolordir/colord/IFRA26S_2004_newsprint.icc
%_icccolordir/colord/SNAP*.icc
%_icccolordir/colord/SWOP*.icc
%endif

# other colorspaces not often used
%_icccolordir/colord/BestRGB.icc
%_icccolordir/colord/BetaRGB.icc
%_icccolordir/colord/BruceRGB.icc
%_icccolordir/colord/DonRGB4.icc
%_icccolordir/colord/ECI-RGBv1.icc
%_icccolordir/colord/ECI-RGBv2.icc
%_icccolordir/colord/EktaSpacePS5.icc
%_icccolordir/colord/WideGamutRGB.icc

# other named color profiles not generally useful
%_icccolordir/colord/Crayons.icc

%files -n lib%name
%_libdir/libcolord.so.*
%_libdir/libcolordprivate.so.*
%_libdir/libcolorhug.so.*
%{?_enable_libcolordcompat:%_libdir/libcolordcompat.so}

%files -n lib%name-devel
%_includedir/colord-1/
%_libdir/lib%name.so
%_libdir/pkgconfig/%name.pc
%_libdir/libcolordprivate.so
%_libdir/libcolorhug.so
%_pkgconfigdir/colorhug.pc

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Colord-1.0.typelib
%_typelibdir/Colorhug-1.0.typelib

%files -n lib%name-gir-devel
%_girdir/Colord-1.0.gir
%_girdir/Colorhug-1.0.gir
%endif

%if_enabled vala
%files -n lib%name-vala
%_datadir/vala/vapi/%name.vapi
%_datadir/vala/vapi/%name.deps
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name/
%_datadir/installed-tests/%name/
%endif

%if_enabled docs
%files devel-doc
%_datadir/gtk-doc/html/%name
%endif

%changelog
