%define ver_major 0.3
%define xdg_name org.gnome.dfeet
%def_enable tests
%def_disable check

Name: d-feet
Version: %ver_major.16
Release: alt1

Summary: A powerful D-Bus Debugger
Group: Development/Tools
License: GPLv2+
Url: https://wiki.gnome.org/DFeet/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

Requires: dbus-tools-gui

BuildRequires(pre): meson rpm-build-gir rpm-build-python3
BuildRequires: python3-module-pygobject3-devel python3-module-setuptools
BuildRequires: yelp-tools libgtk+3-devel libgtk+3-gir-devel >= 3.9.4
BuildRequires: dbus-tools-gui
%{?_enable_tests:BuildRequires: python3-tools-pep8 python3-module-pycodestyle}

%description
D-Feet is an easy to use D-Bus debugger.

D-Bus is a messaging library used on the Desktop. D-Feet can be used to
inspect D-Bus objects of running programs and invoke methods on those
objects.

%prep
%setup
sed -i 's/\(pycodestyle\)-3/\1.py3/' src/tests/meson.build

%build
%meson %{?_disable_tests:-Dtests=false}
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name dfeet

%check
%meson_test

%files -f %name.lang
%_bindir/%name
%python3_sitelibdir_noarch/dfeet
%_datadir/%name/
%_datadir/applications/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS README* NEWS

%changelog
