%define major 2.0

Name: deluge
Version: %major.3
Release: alt2

Summary: full-featured BitTorrent client
License: GPL-3.0-or-later with OpenSSL exception
Group: Networking/File transfer

Url: http://deluge-torrent.org

# repacked https://ftp.osuosl.org/pub/deluge/source/%major/deluge-%version.tar.xz
Source: %name-%version.tar
Source1: deluged.service
Source2: deluge-web.service
Patch1: deluge-2.0.3-alt-setup-no-requires.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): libappindicator-gtk3-gir-devel librsvg-devel
# Automatically added by buildreq on Sun Mar 22 2020
# optimized out: libboost_python3-1.72.0 libtorrent-rasterbar10 perl perl-Encode perl-XML-Parser perl-parent python2-base python3 python3-base python3-dev python3-module-pkg_resources sh4
BuildRequires: intltool python3-module-chardet python3-module-libtorrent-rasterbar python3-module-setuptools

Requires: deluge-gtk

%description
Deluge is a full-featured  BitTorrent client for Linux, OS X, Unix and
Windows. It uses  libtorrent in it's backend and features multiple
user-interfaces including: GTK+, web and console. It has been designed
using the client server model with a daemon process that handles all the
bittorrent activity. The Deluge daemon is able to run on headless
machines with the user-interfaces being able to connect remotely from
any platform.

Deluge features a rich plugin collection; in fact, most of Deluge's
functionality is available in the form of plugins.

Deluge was created with the intention of being lightweight and
unobtrusive. It is our belief that downloading shouldn't be the primary
task on your computer and therefore shouldn't monopolize system
resources.

Deluge is not designed for any one desktop environment and will work
just fine in GNOME, KDE, XFCE and others. We do our best to adhere to
the  freedesktop standards.

Deluge is  Free Software and is licensed under the  GNU General Public
License.

%package -n python3-module-deluge
Group: Networking/File transfer
Summary: full-featured BitTorrent client (common files)
Requires: python3-module-simplejson python3-module-pyxdg python3-module-libtorrent-rasterbar python3-module-twisted-web
Requires: python3-module-service-identity python3-module-Pillow python3-module-chardet python3-module-setproctitle
# https://bugzilla.altlinux.org/show_bug.cgi?id=39192
Requires: GConf

%description -n python3-module-deluge
This package contains data files commons to both the deluge daemon and
the user-interfaces.

%package console
Group: Networking/File transfer
Summary: full-featured BitTorrent client (console UI)
Requires: python3-module-deluge

%description console
This package contains the console user-interface.

%package -n deluged
Group: Networking/File transfer
Summary: full-featured BitTorrent client (deluge daemon)
Requires: python3-module-deluge

%description -n deluged
Deluge daemon process handles all the bittorrent activity.
The Deluge daemon is able to run on headless machines with the
user-interfaces being able to connect remotely from any platform.

%package gtk
%filter_from_requires '/^python3\(gi\.repository/d'
Group: Networking/File transfer
Summary: full-featured BitTorrent client (GTK UI)
Requires: python3-module-deluge python3-module-twisted-core-gui python3-module-pygobject3-pygtkcompat

%description gtk
This package contains the GTK user-interface.

%package web
Group: Networking/File transfer
Summary: full-featured BitTorrent client (web UI)
Requires: python3-module-deluge

%description web
This package contains the web user-interface.

%prep
%setup -q
cp -a %SOURCE1 .
cp -a %SOURCE2 .
%patch1 -p2

%build
%python3_build

%install
%python3_install
rm -f %buildroot%_datadir/pixmaps/*
rm -f %buildroot%python_sitelibdir/%name/ui/webui/scripts/build_webui_tarball.sh
mkdir -p %buildroot{%_unitdir,%_spooldir/%{name}d}
cp -a %{name}d.service %buildroot%_unitdir
cp -a %name-web.service %buildroot%_unitdir

%pre -n deluged
%_sbindir/groupadd -r -f _deluge
%_sbindir/useradd -r -n -g _deluge -d %_spooldir/%{name}d -s /dev/null -c "deluge bittorrent daemon" _deluge >/dev/null 2>&1 ||:

%post -n deluged
%post_service deluged

%preun -n deluged
%preun_service deluged

%files
%_bindir/%name
%_man1dir/%name.1*
%doc LICENSE CHANGELOG.md README.md

%files -n python3-module-deluge
%dir %python3_sitelibdir/%name
%python3_sitelibdir/%name/*.py*
%python3_sitelibdir/%name/core
%python3_sitelibdir/%name/ui/data
%python3_sitelibdir/%name/i18n
%python3_sitelibdir/%name/plugins
%dir %python3_sitelibdir/%name/ui
%python3_sitelibdir/%name/ui/*.py*
%python3_sitelibdir/*.egg-info

%files console
%_bindir/%name-console
%_man1dir/%name-console.1*
%python3_sitelibdir/%name/ui/console

%files -n deluged
%_unitdir/%{name}d.service
%_bindir/%{name}d
%_man1dir/%{name}d.1*
%attr(0775,root,_deluge) %dir %_spooldir/%{name}d

%files gtk
%_bindir/%name-gtk
%_man1dir/%name-gtk.1*
%python3_sitelibdir/%name/ui/gtk3
%_iconsdir/hicolor/*/apps/*
%_desktopdir/%name.desktop
%_datadir/appdata/%name.appdata.xml

%files web
%_unitdir/%name-web.service
%_bindir/%name-web
%_man1dir/%name-web.1*
%python3_sitelibdir/%name/ui/web

%changelog
