# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1

Name: dm-secdel
Version: 1.0.9
Release: alt3

Summary: dm-linear with secure deletion on discard
License: GPL-2.0-only
Group: System/Kernel and hardware
Requires: /sbin/dmsetup /sbin/blockdev /usr/bin/expr
BuildArch: noarch

Url: https://github.com/vt-alt/dm-secdel
Source: %name-%version.tar

BuildRequires(pre): rpm-build-kernel
%{?!_without_check:%{?!_disable_check:
BuildRequires: banner
BuildRequires: kernel-headers-modules-std-def
BuildRequires: kernel-headers-modules-un-def
BuildRequires: rpm-build-vm
}}

%description
Linear device-mapper target with secure deletion on discard.

%package -n kernel-source-%name
Summary: dm-linear with secure deletion on discard (source)
Group: Development/Kernel
BuildArch: noarch

%description -n kernel-source-%name
Linear device-mapper target with secure deletion on discard (source).

%prep
%setup

%install
make install-bin DESTDIR=%buildroot
install -pDm0644 %_sourcedir/%name-%version.tar %kernel_srcdir/kernel-source-%name-%version.tar
mkdir %buildroot/etc
echo '# <target name> <source device> <options>' > %buildroot/etc/secdeltab

%check
# Do a dummy build of the module.
banner std-def
make KDIR=$(echo /lib/modules/*-std-def-*/build) VERSION=%version clean all
# Cannot run tests, because "forbidden dependencies: kernel-image-std-def"

# Build and run functional tests
banner un-def
make KDIR=$(echo /lib/modules/*-un-def-*/build) VERSION=%version clean all
[ "$HOSTTYPE" = armh ] || \
timeout 60 \
vm-run --kvm=cond --sbin --udevd --kernel=un-def ./tests.sh

%files -n kernel-source-%name
%kernel_src/kernel-source-%name-%version.tar

%files
%doc README.md
%config /etc/secdeltab
/sbin/secdelsetup
%_unitdir/secdeltab.service

%post
%post_service secdeltab
systemctl -q enable secdeltab

%preun
%preun_service secdeltab

%changelog
