%global pkg_name github.com/docker/compose/v2

%global __find_debuginfo_files %nil
%global _unpackaged_files_terminate_build 1

%set_verify_elf_method unresolved=no
%add_debuginfo_skiplist %_bindir
%brp_strip_none %_bindir/*

%define binname docker-compose

Name:		docker-compose-v2
Version:	2.29.7
Release:	alt2
Summary:	Multi-container orchestration for Docker

Group:		Development/Tools
License:	Apache-2.0
URL:		https://github.com/docker/compose

Packager:	Vladimir Didenko <cow@altlinux.org>

Source0: %name-%version.tar

ExclusiveArch: %go_arches

Requires: /usr/bin/docker

BuildRequires(pre): rpm-build-golang
BuildRequires: golang
Provides: docker-compose = %version-%release
Obsoletes: docker-compose <= 1.29.2

%description
Docker Compose is a tool for running multi-container applications
on Docker defined using the Compose file format. A Compose file is
used to define how the one or more containers that make up your
application are configured. Once you have a Compose file, you can
create and start your application with a single command: docker compose up.

%prep
%setup -q

%build
export VERSION=%version
export BUILD_TAGS=e2e,kube
export PKG_NAME=%pkg_name

go build -ldflags "-s -w -X ${PKG_NAME}/internal.Version=${VERSION}" -mod=vendor -tags "$BUILD_TAGS" -o %binname cmd/main.go

%install
# install main binary
mkdir -p -- %buildroot%{_libexecdir}/docker/cli-plugins
install -Dpm0755 %binname %buildroot%{_libexecdir}/docker/cli-plugins

%files
%doc docs
%{_libexecdir}/docker/cli-plugins/%binname

%changelog
