# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name:    drgn
Version: 0.0.13
Release: alt1
Summary: Scriptable debugger library
License: GPL-3.0-or-later
Group:   Development/Debuggers
URL:     https://drgn.readthedocs.io
Vcs:     https://github.com/osandov/drgn
# Docs:  https://drgn.readthedocs.io/en/latest/
# Press: https://lwn.net/Articles/789641/
# Conf:  https://linuxplumbersconf.org/event/4/contributions/440/
# Refs:  https://www.kernel.org/doc/html/latest/bpf/drgn.html
Provides: python-module-drgn

Source: %name-%version.tar
ExclusiveArch: x86_64

BuildRequires(pre): rpm-build-python3
BuildRequires: bzip2-devel
BuildRequires: flex
BuildRequires: git-core
BuildRequires: libdw-devel
BuildRequires: libelf-devel
BuildRequires: libgomp-devel
BuildRequires: liblzma-devel
BuildRequires: libstdc++-devel
BuildRequires: zlib-devel
# BuildRequires: libkdumpfile
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc}}
# Note: Bundled with own version of elfutils.

%description
drgn (pronounced "dragon") is a debugger with an emphasis on programmability.
drgn exposes the types and variables in a program for easy, expressive
scripting in Python. For example, you can debug the Linux kernel.

%prep
%setup

%build
git init # Fool it to believe it's installing from the git
sed -i '/local_version.*unknown/s/+unknown/-%release/' setup.py
%python3_build

%install
%python3_install

%check
# Build-in tests (require /proc)
%__python3 setup.py test

# Simple test
export PYTHONPATH=%buildroot%python3_sitelibdir
%buildroot%_bindir/drgn --version

%files
%doc COPYING README.rst
%_bindir/drgn
%python3_sitelibdir/drgn*.egg-info
%python3_sitelibdir/drgn
%python3_sitelibdir/_drgn.*

%changelog
