Name: dstat
Version: 0.7.4
Release: alt1

Summary: Versatile vmstat, iostat and ifstat replacement
License: GPL-2.0
Group: Monitoring

URL: http://dag.wieers.com/home-made/dstat
Packager: Michael Shigorin <mike@altlinux.org>
# 0.7.4 from https://github.com/dagwieers/dstat
Source: %url/%name-%version.tar.bz2
Source1: dstat.desktop

Patch1: use-python3-compatible-way-of-checking-instance-type.patch
Patch2: use-collections.abc-instead-of-collections.patch

Requires: python3
BuildArch: noarch

BuildRequires: python3-base rpm-build-python3

%description
Dstat is a versatile replacement for vmstat, iostat and ifstat.
It overcomes some of the limitations and adds some extra features.

Dstat allows you to view all of your system resources instantly,
you can eg. compare disk usage in combination with interrupts from
your IDE controller, or compare the network bandwidth numbers
directly with the disk throughput (in the same interval).

Dstat also cleverly gives you the most detailed information in
columns and clearly indicates in what magnitude and unit the output
is displayed. Less confusion, less mistakes.

Dstat is also unique in letting you aggregate block device throughput
for a certain diskset or network bandwidth for a group of interfaces,
ie. you can see the throughput for all the block devices that make up
a single filesystem or storage system.

You can customize your dstat output from /etc/dstat.conf and you can
write your own dstat modules to plug into the dstat output.

Dstat's output, in its current form, is not very useful to be post-
processed by other tools. It's mostly meant for allowing humans to
interprete real-time data as easy as possible.

%prep
%setup
# replace env by python
sed -i 's/#!\/usr\/bin\/env python/#!\/usr\/bin\/python3/' dstat
%patch1 -p1
%patch2 -p1

%build
%install
%makeinstall

install -D -m 0644 "%SOURCE1" "%buildroot%_datadir/applications/%name.desktop"

%files
%doc AUTHORS ChangeLog README* TODO
%doc %_man1dir/*
%_bindir/*
%_datadir/%name/
%_datadir/applications/dstat.desktop

%changelog
