%define _unpackaged_files_terminate_build 1

%def_with check

Name: elixir
Version: 1.17.3
Release: alt1
Summary: A modern approach to programming for the Erlang VM
License: Apache-2.0
Group: Development/Other
Url: http://elixir-lang.org/
VCS: https://github.com/elixir-lang/elixir.git

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-erlang
BuildRequires: erlang-devel
BuildRequires: erlang-otp-devel
BuildRequires: rebar

%if_with check
BuildRequires: /dev/pts
BuildRequires: git
%endif

%description
Elixir is a programming language built on top of the Erlang VM.
As Erlang, it is a functional language built to support distributed,
fault-tolerant, non-stop applications with hot code swapping.

%prep
%setup
find -name '*.bat' -exec rm \{\} \;

# Fix build with make 4.4
# https://github.com/elixir-lang/elixir/pull/12244
sed -i '/.NOTPARALLEL/ s/ compile//' Makefile

%build
export LANG="en_US.UTF-8"
%make_build compile
%make_build build_man

%install
mkdir -p %buildroot/%_datadir/%name/%version
cp -ra bin lib %buildroot/%_datadir/%name/%version

mkdir -p %buildroot/%_bindir
ln -s %_datadir/%name/%version/bin/{elixir,elixirc,iex,mix} %buildroot/%_bindir/

mkdir -p %buildroot/%_mandir/man1
cp -a man/elixir.1 man/elixirc.1 man/iex.1 man/mix.1 %buildroot/%_mandir/man1

%check
export LANG="en_US.UTF-8"
%make_build test

%files
%doc LICENSE
%_bindir/elixir
%_bindir/elixirc
%_bindir/iex
%_bindir/mix
%_datadir/%name
%_mandir/man1/*

%changelog
