%define git %nil

Name: ell
Version: 0.64
Release: alt1
Summary: Embedded Linux library
Group: System/Libraries
License: LGPLv2+
Url: https://01.org/ell
Source0: https://www.kernel.org/pub/linux/libs/%name/%name-%version.tar
Patch: %name-%version-%release.patch

%description
The Embedded Linux* Library (ELL) provides core, low-level functionality for
system daemons. It typically has no dependencies other than the Linux kernel, C
standard library, and libdl (for dynamic linking). While ELL is designed to be
efficient and compact enough for use on embedded Linux platforms, it is not
limited to resource-constrained systems.

%package -n lib%name
Summary: Embedded Linux library
Group: System/Libraries

%description -n lib%name
The Embedded Linux* Library (ELL) provides core, low-level functionality for
system daemons. It typically has no dependencies other than the Linux kernel, C
standard library, and libdl (for dynamic linking). While ELL is designed to be
efficient and compact enough for use on embedded Linux platforms, it is not
limited to resource-constrained systems.

%package -n lib%name-devel
Summary: Embedded Linux library development files
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Headers for developing against libell.

%prep
%setup

%build
%autoreconf
%configure
%make_build V=1

%install
%set_verify_elf_method unresolved=relaxed
%makeinstall

%files -n lib%name
%_libdir/libell.so.*
%doc AUTHORS README TODO ChangeLog COPYING

%files -n lib%name-devel
%_includedir/ell
%_libdir/libell.so
%_pkgconfigdir/ell.pc

%changelog
