%define _unpackaged_files_terminate_build 1

%define libsuffix 3
%define soname 3

Name: embree
Version: 3.13.0
Release: alt3
Summary: Collection of high-performance ray tracing kernels developed at Intel
Group: Graphics
License: Apache-2.0
URL: https://embree.github.io

# https://github.com/embree/embree.git
Source: %name-%version.tar

Source1: %name.watch

Patch2000: %name-e2k.patch

BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libgif-devel
%ifarch x86_64 %ix86
BuildRequires: ispc
%endif
BuildRequires: pkgconfig(glut)
BuildRequires: pkgconfig(glfw3)
BuildRequires: pkgconfig(xmu)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libopenjp2)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(libtiff-4)
BuildRequires: pkgconfig(OpenImageIO)
BuildRequires: pkgconfig(tbb)

ExclusiveArch: x86_64 %ix86 aarch64 %e2k

%description
A collection of high-performance ray tracing kernels intended to graphics 
application engineers that want to improve the performance of their application.

%package -n lib%{name}%{libsuffix}-%soname
Summary: Collection of high-performance ray tracing kernels developed at Intel
Group: System/Libraries

%description -n lib%{name}%{libsuffix}-%soname
A collection of high-performance ray tracing kernels intended to graphics 
application engineers that want to improve the performance of their application.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: lib%{name}%{libsuffix}-%soname = %EVR

%description devel
The %{name}-devel package contains libraries and header files for
applications that use %{name}.

%prep
%setup
%ifarch %e2k
%patch2000 -p1
%endif

%ifarch %ix86
# _mm_cvtsi128_si64 is unavailable on 32-bit x86
sed -i "s|defined(__WIN32__) && !defined(__X86_64__)|!defined(__64BIT__)|" \
	common/simd/vint4_sse2.h
sed -i "/return _mm_cvtsi128_si64/s|.*|return v.i[0];|" \
	common/simd/vllong4_avx2.h
%endif

%build
# limit parallel build
if [ %__nprocs -gt 4 ] ; then
	export NPROCS=4
fi

%ifarch %e2k
%add_optflags -Wno-reduced-alignment -Wno-sign-compare -mno-avx
%endif

%cmake \
	-DEMBREE_IGNORE_CMAKE_CXX_FLAGS=OFF \
	-DEMBREE_TUTORIALS=OFF \
	-DEMBREE_COMPACT_POLYS=ON \
%ifnarch x86_64 %ix86
	-DEMBREE_ISPC_SUPPORT=OFF \
%endif
%ifarch %ix86
	-DEMBREE_MAX_ISA=AVX2 \
%endif
%ifarch %e2k
	-DEMBREE_MAX_ISA=DEFAULT \
%endif
	%nil

%cmake_build

%install
%cmakeinstall_std

# Remove unpackaged files
rm -rf %buildroot%_docdir/%{name}%{libsuffix}

%files -n lib%{name}%{libsuffix}-%soname
%doc LICENSE.txt
%doc README.md CHANGELOG.md readme.pdf third-party-programs-TBB.txt third-party-programs.txt
%_libdir/lib%{name}%{libsuffix}.so.%{soname}
%_libdir/lib%{name}%{libsuffix}.so.%{soname}.*

%files devel
%_libdir/lib%{name}%{libsuffix}.so
%_includedir/%{name}%{libsuffix}/
%_libdir/cmake/%name-%version/
%_man3dir/*

%changelog
