%def_disable snapshot
%define beta %nil

%def_enable video
%def_enable webready
%def_disable ssh
%def_disable tests
%def_disable check

%ifnarch %e2k
%define gcc_ver 9
%define optflags_lto %nil
%set_gcc_version %gcc_ver
%else
%define gcc_ver %nil
%endif

Name: exiv2
Version: 0.27.7
Release: alt2
%define sover 27
%define libexiv2 libexiv2_%sover

Summary: Command line tool to access EXIF data in image files
License: GPL-2.0-or-later
Group: Graphics
Url: http://www.exiv2.org

%if_disabled snapshot
Source: https://github.com/Exiv2/%name/archive/v%version/%name-%version.tar.gz
%else
Vcs: https://github.com/Exiv2/exiv2.git
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc%gcc_ver-c++ libexpat-devel zlib-devel
BuildRequires: doxygen xsltproc graphviz
%{?_enable_tests:BuildRequires: libgtest-devel}
%{?_enable_webready:BuildRequires: libcurl-devel libssh-devel libgcrypt-devel}
%{?_enable_check:BuildRequires: ctest}

%description
Exiv2 comprises of a C++ library and a command line utility to access
image metadata. Exiv2 supports full read and write access to the EXIF and
IPTC metadata, EXIF MakerNote support, extract and delete methods for
EXIF thumbnails, classes to access IFD and so on.

%package -n %libexiv2
Summary: EXIF and IPTC metadata manipulation library
Group: Graphics
Provides: libexiv2 = %version
Obsoletes: libexiv2 <= 0.27.7-alt1.1

%description -n %libexiv2
libexiv2 is a C++ library to access image metadata.

%package -n libexiv2-devel
Summary: Headers and links to compile against the exiv2 library
Group: Development/C

%description -n libexiv2-devel
This package contains all files which one needs to compile programs using the
exiv2 library.

%prep
%setup -n %name-%version

%build
%add_optflags -Wno-deprecated-declarations %(getconf LFS_CFLAGS)
%cmake \
	-DEXIV2_ENABLE_NLS:BOOL=ON \
	-DEXIV2_BUILD_SAMPLES:BOOL=OFF \
	-DEXIV2_ENABLE_BMFF:BOOL=ON \
	%{?_enable_video:-DEXIV2_ENABLE_VIDEO:BOOL=ON} \
	%{?_enable_webready:-DEXIV2_ENABLE_WEBREADY:BOOL=ON} \
	%{?_enable_ssh:-DEXIV2_ENABLE_SSH:BOOL=ON} \
	%{?_enable_tests:-DEXIV2_BUILD_UNIT_TESTS:BOOL=ON}
%nil
%cmake_build

%install
%cmake_install
%find_lang exiv2

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%cmake_build -t tests

%files
%_bindir/%name
%_man1dir/*
%doc README* doc/ChangeLog

%files -n %libexiv2
%_libdir/lib%name.so.%sover
%_libdir/lib%name.so.*

%files -n libexiv2-devel
%_libdir/lib%name.so
%_libdir/libexiv2-xmp.a
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_libdir/cmake/%name/


%changelog
