Name: expat
Version: 2.5.0
Release: alt1

%def_disable static
%define pkgdocdir %_docdir/%name-%version

Summary: An XML parser written in C
License: MIT
Group: System/Base
Url: http://www.libexpat.org/
# http://downloads.sourceforge.net/project/expat/expat/%version/expat-%version.tar.bz2
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: lib%name = %version-%release

# for "make check"
BuildRequires: gcc-c++

%package -n lib%name
Summary: XML parser library
Group: System/Libraries

%package -n lib%name-devel
Summary: Development files for Expat, an XML parser library for C
Group: Development/C
Requires: lib%name = %version-%release
Provides: expat-devel = %version
Obsoletes: expat-devel

%package -n lib%name-devel-static
Summary: Static library for developing static applications which will manipulate XML files
Group: Development/C
Requires: lib%name-devel = %version-%release

%description
Expat is a stream-oriented XML parser written in C.

%description -n lib%name
Expat is a stream-oriented XML parser written in C.
This package provides the Expat parser as a shared library.

%description -n lib%name-devel
Expat is a stream-oriented XML parser written in C.
This package is needed if you want to build programs which use Expat
library.

%description -n lib%name-devel-static
Expat is a stream-oriented XML parser written in C.
This package provides the Expat parser as a library for static linking.

%prep
%setup
%patch -p1

%build
%autoreconf
export DOCBOOK_TO_MAN="xmlto man --skip-validation"
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std

# Relocate shared library from /usr/lib to /lib.
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/libexpat.so.1* %buildroot/%_lib
rm %buildroot%_libdir/libexpat.so
ln -s ../../%_lib/libexpat.so.1 %buildroot%_libdir/libexpat.so

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS README.md COPYING Changes %buildroot%pkgdocdir/
install -p -m644 doc/*.{html,css} %buildroot%pkgdocdir/
install -d -m755 %buildroot%pkgdocdir/examples
install -p -m644 examples/*.c %buildroot%pkgdocdir/examples/

%check
%make_build -k check

%files
%_bindir/*
%_man1dir/*

%files -n lib%name
/%_lib/*.so.*
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/Changes
%pkgdocdir/COPYING
%pkgdocdir/README.md

%files -n lib%name-devel
%_libdir/*.so
%_libdir/cmake/expat-%version
%_includedir/*
%_pkgconfigdir/*.pc
%dir %pkgdocdir
%pkgdocdir/*.html
%pkgdocdir/*.css
%pkgdocdir/examples

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif	# enabled static

%changelog
