Name: findutils
Version: 4.8.0.0.10.1157
Release: alt1

Summary: The GNU versions of find utilities (find and xargs)
License: GPLv3+
Group: File tools
Url: https://www.gnu.org/software/findutils/

# git://git.altlinux.org/gears/f/findutils.git
Source: %name-%version-%release.tar

%def_enable selinux

BuildRequires: gnulib >= 0.1.4669.fed6f
BuildRequires: glibc-devel-static
BuildRequires: makeinfo
%{?_enable_selinux:BuildRequires: libselinux-devel}
%{?!_without_check:%{?!_disable_check:BuildRequires: dejagnu}}

%package -n find-static
Summary: Static version of the GNU find
Group: File tools
Requires: %name = %version-%release

%description
This package contains programs which will help you locate files on
your system:
+ the find utility searches through a hierarchy of directories
  looking for files which match a certain set of criteria
  (such as a filename pattern);
+ the xargs utility builds and executes command lines from standard
  input arguments (usually lists of file names generated by the find
  command).

%description -n find-static
This package contains statically linked version of the GNU find program.

%prep
%setup -n %name-%version-%release

# Build scripts expect to find findutils version in this file.
echo -n %version > .tarball-version

# git isn't needed for build.
sed -i '/^git[[:space:]]/d' bootstrap.conf

# Do not build locate.
sed -i 's/ locate / /' Makefile*

echo '@set LOCATE_DB /var/lib/locate/locatedb' >locate/dblocation.texi

gzip -9kn NEWS

%build
./bootstrap --skip-po --gnulib-srcdir=%_datadir/gnulib

%define _configure_script ../configure
mkdir dynamic static

pushd dynamic
mkdir locate
echo '@set LOCATE_DB /var/lib/locate/locatedb' >locate/dblocation.texi
# Since find and xargs are not threaded executables,
# configure gnulib with --disable-threads.
%configure --disable-threads --bindir=/bin
%make_build MAKEINFOFLAGS=--no-split
popd

pushd static
%configure --disable-nls --disable-threads --without-selinux
# Do not build xargs and doc.
sed -i -e 's/ xargs / /' -e 's/ doc / /' Makefile*
%make_build
rm find/find
make -C find find LDFLAGS=-static
popd

%install
%makeinstall_std -C dynamic
mkdir -p %buildroot%_bindir
for n in find xargs; do
	ln -s "../../bin/$n" %buildroot%_bindir/
done

# Install find.static
install -pm755 static/find/find %buildroot%_bindir/find.static

%find_lang %name

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
# section [ 3] '.rela.plt': relocation 0: invalid symbol index
# ...
# section [ 3] '.rela.plt': relocation 34: invalid symbol index
# verify-elf: ERROR: ./usr/bin/find.static: eu-elflint failed
%set_verify_elf_method strict,lint=relaxed

%check
%make_build -k check -C dynamic
env PATH="%buildroot/bin:$PATH" \
%make_build -k check -C static

%files -f %name.lang
/bin/find
/bin/xargs
%_bindir/find
%_bindir/xargs
%_mandir/man?/find*
%_mandir/man?/xargs*
%_infodir/*.info*
%doc AUTHORS NEWS.gz README THANKS

%files -n find-static
%_bindir/find.static

%changelog
