Name: firewalld
Version: 0.9.11
Release: alt1

Summary: A firewall daemon with D-BUS interface providing a dynamic firewall
License: GPLv2+
Group: System/Configuration/Networking

URL: https://www.firewalld.org/
Vcs: https://github.com/firewalld/firewalld
Source: %name-%version.tar
Source1: %name.init
Patch: %name-%version-%release.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-xdg python3-devel
BuildRequires: intltool xsltproc docbook-style-xsl docbook-dtds glib2-devel libgio-devel

Requires: iptables ebtables iptables-ipv6
Requires: python3-module-nftables >= 0.9.3-alt2
Requires: libnftables >= 0.9.3-alt2

%allow_python3_import_path %_datadir/firewalld
%add_python3_path %_datadir/firewalld

%define _unpackaged_files_terminate_build 1

%description
firewalld is a firewall service daemon that provides a dynamic
customizable firewall with a D-BUS interface.

%package -n firewall-config
Summary: Firewall configuration application
Group: System/Configuration/Networking
Requires: %name = %version-%release
Requires: libnm-gir

%description -n firewall-config
The firewall configuration application provides an configuration interface
for firewalld.

%package -n firewall-applet
Summary: Firewall panel applet
Group: System/Configuration/Networking
Requires: firewall-config = %version-%release
Requires: libnm-gir
Requires: libnotify-gir

%description -n firewall-applet
The firewall panel applet provides a status information of firewalld and
also the firewall settings.

%package -n python3-module-firewall
Summary: Python3 bindings for firewalld
Group: Development/Python3

%description -n python3-module-firewall
Python3 bindings for firewalld.

%prep
%setup
%patch -p1

%build
%autoreconf
export PYTHON=/usr/bin/python3
%configure \
	--enable-sysconfig \
	--enable-systemd \
	--localstatedir=%_var \
	--with-systemd-unitdir=%systemd_unitdir \
	--with-iptables=/sbin/iptables \
	--with-iptables-restore=/sbin/iptables-restore \
	--with-ip6tables=/sbin/ip6tables \
	--with-ip6tables-restore=/sbin/ip6tables-restore \
	--with-ebtables=/sbin/ebtables \
	--with-ebtables-restore=/sbin/ebtables-restore \
	--with-ipset=/sbin/ipset
%make
make update-po

%install
%makeinstall_std PYTHON=/usr/bin/python3
pushd po
make install DESTDIR=%buildroot
popd
%find_lang %name
install -pDm755 %SOURCE1 %buildroot%_initdir/%name

# Most tests require root
#check
#make check

%post
%post_service %name

%preun
%preun_service %name

%files -f %name.lang
%_sbindir/*
%_bindir/firewall-cmd
%_bindir/firewall-offline-cmd
%attr(0750,root,root) %config(noreplace) %_sysconfdir/firewalld
%attr(0640,root,root) %config(noreplace) %_sysconfdir/firewalld/firewalld.conf
%config(noreplace) %_sysconfdir/sysconfig/firewalld
%_initdir/%name
%_usr/lib/firewalld
%systemd_unitdir/firewalld.service
%config %_sysconfdir/modprobe.d/firewalld-sysctls.conf
%config %_sysconfdir/logrotate.d/*
%config %_datadir/dbus-1/system.d/FirewallD.conf
%_datadir/polkit-1/actions/org.fedoraproject.FirewallD1.policy
%_datadir/polkit-1/actions/org.fedoraproject.FirewallD1.desktop.policy.choice
%_datadir/polkit-1/actions/org.fedoraproject.FirewallD1.server.policy.choice
%_datadir/bash-completion/completions/*
%_datadir/zsh/site-functions/*
%_man1dir/*
%_man5dir/*
%exclude %_man1dir/firewall-config*.1*

%files -n firewall-config
%_bindir/firewall-config
%_datadir/firewalld/
%_datadir/applications/firewall-config.desktop
%_datadir/metainfo/firewall-config.appdata.xml
%_iconsdir/hicolor/*/apps/firewall-config*
%_datadir/glib-2.0/schemas/org.fedoraproject.FirewallConfig.gschema.xml
%_man1dir/firewall-config*.1*

%files -n firewall-applet
%dir %_sysconfdir/firewall
%config(noreplace) %_sysconfdir/firewall/applet.conf
%_bindir/firewall-applet
%_xdgconfigdir/autostart/firewall-applet.desktop
%_iconsdir/hicolor/*/apps/firewall-applet*

%files -n python3-module-firewall
%python3_sitelibdir_noarch/firewall

%changelog
