%define orig_name intel-microcode
%define orig_timestamp 20240813
%define orig_rev %nil

Name: firmware-intel-ucode
Version: 27
Release: alt1.%{orig_timestamp}%{?orig_rev}
Epoch: 2

Packager: L.A. Kostis <lakostis@altlinux.org>

Summary: Microcode definitions for Intel processors
License: INTEL SOFTWARE LICENSE AGREEMENT
Group: System/Kernel and hardware
Provides: microcode-data-intel = %version-%release
Obsoletes: microcode-data-intel <= 20130222-alt2

URL: https://salsa.debian.org/hmh/intel-microcode.git
Source0: %{orig_name}-%{orig_timestamp}%{?orig_rev}.tar

BuildRequires: iucode_tool

# beware that this probably should be ix86
# but who cares about intel on ARM?
BuildArch: noarch
ExclusiveArch: %ix86 x86_64

%description
The microcode data file for Linux contains the latest microcode
definitions for all Intel processors.

%prep
%setup -q -n %orig_name-%{orig_timestamp}%{?orig_rev}

%build
%make_build

%install
mkdir -p %buildroot/lib/firmware/intel-ucode
UCODE=intel-microcode
%ifarch %ix86
# use stripped down version for x86_64 and ia32
UCODE=${UCODE}-64
%endif
mv ${UCODE}.bin %buildroot/lib/firmware/intel-ucode/%{orig_name}.bin

%files
%doc license changelog releasenote.md security.md
%dir /lib/firmware/intel-ucode
/lib/firmware/intel-ucode/*

%changelog
