%define soname 1
Name: flashrom
Version: 1.4.0
Release: alt0.p10.1

Summary: Universal flash programming utility
License: GPLv2
Group: System/Kernel and hardware

Url: http://flashrom.org/Flashrom
# Homepage: http://www.flashrom.org
# https://review.coreboot.org/flashrom.git
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: %name-alt-manpage.patch

BuildRequires: libftdi1-devel libpci-devel zlib-devel libusb-devel
BuildRequires: libjaylink-devel libcmocka-devel libpci-devel
BuildRequires: gcc meson python3-module-sphinx-sphinx-build-symlink

# https://github.com/flashrom/flashrom/issues/186
# https://bugzilla.redhat.com/show_bug.cgi?id=1693831
%global optflags_lto %nil

%description
flashrom is a tool for identifying, reading, writing,
verifying and erasing flash chips. It's often used to flash
BIOS/EFI/coreboot/firmware/optionROM images in-system using a
supported mainboard, but it also supports flashing of network
cards (NICs), SATA controller cards, and other external devices
which can program flash chips.

It supports a wide range of DIP32, PLCC32, DIP8, SO8/SOIC8,
TSOP32/40/48, and BGA chips, which use various protocols such as
LPC, FWH, parallel flash, or SPI.

The tool can be used to flash BIOS/firmware images for example --
be it proprietary BIOS images or coreboot (previously known as
LinuxBIOS) images.

It can also be used to read the current existing BIOS/firmware
from a flash chip.

%package -n libflashrom%soname
Summary: Shared library for %name
Group: System/Libraries
Requires: %name = %EVR

%description -n libflashrom%soname
Shared library for %name.

flashrom is a tool for identifying, reading, writing,
verifying and erasing flash chips. It's often used to flash
BIOS/EFI/coreboot/firmware/optionROM images in-system using a
supported mainboard, but it also supports flashing of network
cards (NICs), SATA controller cards, and other external devices
which can program flash chips.

It supports a wide range of DIP32, PLCC32, DIP8, SO8/SOIC8,
TSOP32/40/48, and BGA chips, which use various protocols such as
LPC, FWH, parallel flash, or SPI.

The tool can be used to flash BIOS/firmware images for example --
be it proprietary BIOS images or coreboot (previously known as
LinuxBIOS) images.

It can also be used to read the current existing BIOS/firmware
from a flash chip.


%package -n lib%name-devel
Summary: Development package for %name
Group: Development/C
Requires: lib%name%soname = %EVR

%description -n lib%name-devel
Files for development with %{name}.

%package doc
Summary: %name html documentation
Group: Documentation
BuildArch: noarch

%description doc
%name html documentation

%package -n bash-completion-%name
Summary: Bash completion for %name
Group: Shells
BuildArch: noarch
Requires: bash-completion
Requires: %name = %version-%release

%description -n bash-completion-%name
Bash completion for %name.

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
echo "VERSION = %version" >versioninfo.inc
echo "MAN_DATE = `date '+%%Y-%%m-%%d'`">>versioninfo.inc
sed -e 's/MODE="[0-9]*", GROUP="plugdev"/TAG+="uaccess"/g' util/flashrom_udev.rules -i
%meson \
  -Dman-pages=enabled \
%ifarch ppc64le
  -Dtests=disabled \
%else
  -Dtests=enabled \
%endif
%ifarch %{ix86} x86_64
  -Dprogrammer=[\'auto\',\'jlink_spi\']
%endif
%meson_build

%install
%meson_install
install -D -p -m 0644 util/flashrom_udev.rules %buildroot/%_udevrulesdir/60_flashrom.rules
rm -f %buildroot%_libdir/libflashrom.a

%check
%__meson_test

%files
%doc README.rst COPYING
%_udevrulesdir/60_flashrom.rules
%_sbindir/*
%_man8dir/*

%files -n libflashrom%soname
%_libdir/libflashrom.so.%{soname}*

%files -n libflashrom-devel
%_libdir/libflashrom.so
%_includedir/libflashrom.h
%_pkgconfigdir/flashrom.pc

%files doc
%_docdir/%name

%files -n bash-completion-%name
%_datadir/bash-completion/completions/*

%changelog
