%def_disable snapshot

%define ver_major 2.6
%define rdn_name com.github.johnfactotum.Foliate



Name: foliate
Version: %ver_major.3
Release: alt1

Summary: A simple and modern GTK eBook reader
License: GPL-3.0
Group: Office
Url: https://github.com/johnfactotum/foliate

%if_disabled snapshot
Source: %url/archive/%version/%name-%version.tar.gz
%else
# VCS: https://github.com/johnfactotum/foliate.git
Source: %name-%version.tar
%endif

%define handy_api_ver 1
%define tracker_api_ver 2.0
%define gjs_ver 1.52
%define iso_codes_ver 3.57

Requires: libgjs >= %gjs_ver dconf iso-codes >= %iso_codes_ver
#Recommends: espeak, espeak-ng or festival

# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GObject)
Requires: typelib(Gspell)
Requires: typelib(Gtk) = 3.0
Requires: typelib(Handy) = %handy_api_ver
Requires: typelib(Pango)
Requires: typelib(Soup)
Requires: typelib(Tracker) = %tracker_api_ver
Requires: typelib(WebKit2)

%add_python3_path %_datadir/%rdn_name

BuildRequires(pre): meson rpm-build-gir rpm-build-python3
BuildRequires: desktop-file-utils libappstream-glib-devel
BuildRequires: libgjs-devel iso-codes-devel >= %iso_codes_ver

%description
Foliate is a simple and modern GTK eBook reader with following features:
- View EPUB, Kindle, FictionBook, Comic book and plain text files
- Two-page view and scrolled view
- Customize font and line-spacing
- Light, sepia, dark, and invert mode
- Reading progress slider with chapter marks
- Bookmarks and annotations
- Find in book
- Quick dictionary lookup

%prep
%setup
# switch python shebangs to python3
sed -i 's|\(#\!/usr/bin/env python\)$|\13|
	s|\(/usr/bin/python\)$|\13|' src/assets/KindleUnpack/*.py

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name %rdn_name

%files -f %name.lang
%_bindir/%rdn_name
%_desktopdir/%rdn_name.desktop
%_datadir/%rdn_name/
%_iconsdir/hicolor/symbolic/apps/%rdn_name-symbolic.svg
%_iconsdir/hicolor/scalable/apps/%rdn_name.svg
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/metainfo/%rdn_name.appdata.xml
%doc README*


%changelog
