%ifndef xmlcatalog
%define xmlcatalog %_sysconfdir/xml/catalog
%endif
%define xmlcatalog_bin %_bindir/xmlcatalog
%define docdir %_docdir/%name
%define sover 1
%define libfontconfig libfontconfig%sover

Name: fontconfig
Version: 2.14.2
Release: alt8

Summary: Font configuration and customization utilities and library
Group: System/Configuration/Other
License: MIT
Url: http://fontconfig.org/

Source: %name-%version.tar
Source1: fontconfig-firsttime
Source2: fontconfig.filetrigger
# FC
Patch1: fontconfig-sleep-less.patch
Patch2: fontconfig-drop-lang-from-pkgkit-format.patch
# ALT
Patch11: alt-symbols-map.patch
Patch12: alt-config.patch
Patch13: alt-fc-conf.patch
Patch14: alt-disable-postscript-aliases.patch

Provides: lib%name = %version
Obsoletes: lib%name < %version
BuildRequires(pre): rpm-build-ubt
BuildRequires: docbook-utils elinks gperf libexpat-devel libfreetype-devel libuuid-devel

%description
Fontconfig is designed to locate fonts within the system and
select them according to requirements specified by applications.

%package -n %libfontconfig
Summary: Library for Font Configuration
Group: System/Libraries
Conflicts: fontconfig < 2.14.2
%description -n %libfontconfig
%name library.

%package devel
Summary: Development files for font configuration and customization library
Group: Development/C
Requires: %name = %version-%release

%description devel
This package includes the fontconfig header files and developer
documentation required for development of fontconfig-based software.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%autoreconf

%build
%configure \
	--disable-static \
	--with-baseconfigdir=%_sysconfdir/fonts \
	--with-default-fonts=%_datadir/fonts \
	--with-cache-dir=%_var/cache/%name \
	--docdir=%docdir \
	--with-default-hinting=full \
	--with-default-sub-pixel-rendering=rgb \
	#

%make PDF_FILES=

%ifarch %ix86
echo "void ___save_i586_fontconfig_package___() {}" >save_i586_fontconfig_package.c
gcc %optflags -c save_i586_fontconfig_package.c -o save_i586_fontconfig_package.o
ld --shared save_i586_fontconfig_package.o -o save_i586_fontconfig_package.so
%endif

%install
%make DESTDIR=%buildroot PDF_FILES= install
install -pm644 AUTHORS README %buildroot%docdir/

> %buildroot%_sysconfdir/fonts/local.conf
install -Dp -m755 %SOURCE1 %buildroot%_sysconfdir/firsttime.d/%name
install -Dp -m755 %SOURCE2 %buildroot%_rpmlibdir/%name.filetrigger

for f in $(ls %buildroot%_datadir/%name/conf.avail/1*.conf | sed -ne 's|\(.*/\)\(.*conf\)|\2|p'); do
	ln -sf ../../..%_datadir/%name/conf.avail/$f %buildroot%_sysconfdir/fonts/conf.d/$f
done

# add compatibility symlinks
find %buildroot/%_datadir/%name/conf.avail/ -type f -name \*.conf | sed -e 's|^.*/||' | \
while read CONF ; do
    ln -sr %buildroot/%_datadir/%name/conf.avail/$CONF %buildroot/%_sysconfdir/fonts/conf.avail/$CONF
done
find %buildroot/%_sysconfdir/fonts/conf.avail/ -type f -name \*.conf | sed -e 's|^.*/||' | \
while read CONF ; do
    ln -sr %buildroot/%_sysconfdir/fonts/conf.avail/$CONF %buildroot/%_datadir/%name/conf.avail/$CONF
done

mkdir -p %buildroot/%_libdir/libfontconfig/
%ifarch %ix86
install -m 0644 save_i586_fontconfig_package.so %buildroot/%_libdir/libfontconfig/
%endif

%find_lang --output=%name.lang --append fontconfig fontconfig-conf

%post
XMLCATALOG_BIN=%xmlcatalog_bin
if [ -e %xmlcatalog -a -x $XMLCATALOG_BIN ]; then
  %xmlcatalog_bin --noout --add system \
    "urn:fontconfig:fonts.dtd" \
    "file://%_datadir/xml/fontconfig/fonts.dtd" \
    %xmlcatalog ||:
fi
[ -n "$DURING_INSTALL" ] || %_sysconfdir/firsttime.d/%name ||:

%postun
XMLCATALOG_BIN=%xmlcatalog_bin
if [ -e %xmlcatalog -a -x $XMLCATALOG_BIN ]; then
  %xmlcatalog_bin --noout --del \
    "urn:fontconfig:fonts.dtd" \
    %xmlcatalog ||:
fi

%triggerpostun -- fontconfig <= 2.14.2-alt7
[ -e '/urn:fontconfig:fonts.dtd' ] && rm -f '/urn:fontconfig:fonts.dtd' ||:

%files -f %name.lang
%_sysconfdir/firsttime.d/%name
%dir %_sysconfdir/fonts
%dir %_sysconfdir/fonts/conf.d
%dir %_sysconfdir/fonts/conf.avail
%config %_sysconfdir/fonts/fonts.conf
%config(noreplace) %_sysconfdir/fonts/conf.avail/*.conf
%_sysconfdir/fonts/conf.d/README
%_sysconfdir/fonts/conf.d/[2-9]*.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-yes-antialias.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-hinting.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-hinting-full.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-scale-bitmap-fonts.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-sub-pixel-rgb.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/11-lcdfilter-default.conf
%ghost %_sysconfdir/fonts/conf.d/10-autohint.conf
%ghost %_sysconfdir/fonts/conf.d/10-no-antialias.conf
%ghost %_sysconfdir/fonts/conf.d/10-hinting-slight.conf
%ghost %_sysconfdir/fonts/conf.d/10-hinting-medium.conf
%ghost %_sysconfdir/fonts/conf.d/10-hinting-none.conf
%ghost %_sysconfdir/fonts/conf.d/10-sub-pixel-none.conf
%ghost %_sysconfdir/fonts/conf.d/10-sub-pixel-bgr.conf
%ghost %_sysconfdir/fonts/conf.d/10-sub-pixel-vbgr.conf
%ghost %_sysconfdir/fonts/conf.d/10-sub-pixel-vrgb.conf
%ghost %_sysconfdir/fonts/conf.d/10-unhinted.conf
%ghost %_sysconfdir/fonts/conf.d/11-lcdfilter-legacy.conf
%ghost %_sysconfdir/fonts/conf.d/11-lcdfilter-light.conf
%ghost %_sysconfdir/fonts/conf.d/11-lcdfilter-none.conf
%ghost %config(missingok,noreplace) %_sysconfdir/fonts/local.conf
%_bindir/fc-*
%ifarch %ix86
%_libdir/libfontconfig/save_i586_fontconfig_package.so
%endif
%_rpmlibdir/%name.filetrigger
%_datadir/%name
%_datadir/xml/%name
%_man1dir/*
%_man5dir/*
%dir %_var/cache/%name
%docdir
%exclude %docdir/%name-devel*

%files -n %libfontconfig
%dir %_libdir/libfontconfig/
%_libdir/libfontconfig.so.%sover
%_libdir/libfontconfig.so.*

%files devel
%_libdir/*.so
%_pkgconfigdir/*.pc
%_includedir/*
%_man3dir/*
%dir %docdir
%docdir/%name-devel*
%_datadir/gettext/its/fontconfig.*

%changelog
