%define _unpackaged_files_terminate_build 1

Name: fprintd
Version: 1.94.4
Release: alt3

Summary: D-Bus service for Fingerprint reader access
License: GPLv2+
Group: System/Servers
Url: https://www.freedesktop.org/wiki/Software/fprint/fprintd
VCS: https://gitlab.freedesktop.org/libfprint/fprintd.git

Source: %name-%version.tar
Source1: system-auth-fprintd
Source2: system-auth-use_first_pass-fprintd

Patch: %name-%version.patch

BuildRequires(pre): meson
BuildRequires(pre): rpm-build-python3

BuildRequires: libgio-devel
BuildRequires: libpam0-devel
BuildRequires: libpolkit-devel
BuildRequires: libsystemd-devel
BuildRequires: libdbus-glib-devel
BuildRequires: libfprint2-gir-devel

BuildRequires: gtk-doc
BuildRequires: intltool
BuildRequires: perl-podlators
BuildRequires: xml-utils
BuildRequires: xsltproc
BuildRequires: docbook-dtds

BuildRequires: pam_wrapper
BuildRequires: rpm-macros-pam0
BuildRequires: libpamtest-devel
BuildRequires: python3-module-libpamtest

BuildRequires: python3-module-pycairo
BuildRequires: python3-module-dbus
BuildRequires: python3-module-dbusmock
BuildRequires: python3-module-pygobject3

Requires: %name-clients = %EVR

%description
D-Bus service to access fingerprint readers.

%package -n pam_fprintd
Summary: PAM module for fingerprint authentication
Provides: pam_fprint
Obsoletes: pam_fprint <= 0.2
Group: System/Base

%description -n pam_fprintd
PAM module that uses the fprintd D-Bus service for fingerprint
authentication.

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/Other
BuildArch: noarch

%description devel
Development documentation for fprintd, the D-Bus service for
fingerprint readers access.

%package clients
Summary: %name clients
Group: System/Base

%description clients
Client appications to access fingerprint readers

%prep
%setup -q
%patch -p1

%build
%meson -Dpam_modules_dir=%_pam_modules_dir
%meson_build

%install
%meson_install
%find_lang %name

mkdir -p %buildroot%_sysconfdir/pam.d
install -m0644 -p %SOURCE1 %buildroot%_sysconfdir/pam.d/
install -m0644 -p %SOURCE2 %buildroot%_sysconfdir/pam.d/

%check
export NPROC=1
meson test -C %{__builddir} --num-processes 1 --no-rebuild --print-errorlogs

%files -f %name.lang
%doc README COPYING AUTHORS TODO
%config(noreplace) %_sysconfdir/fprintd.conf
%_datadir/dbus-1/system.d/net.reactivated.Fprint.conf
%_prefix/lib/fprintd
%_unitdir/fprintd.service
%_datadir/dbus-1/system-services/net.reactivated.Fprint.service
%_datadir/polkit-1/actions/net.reactivated.fprint.device.policy
%_man1dir/fprintd.1*

%files -n pam_fprintd
%doc pam/README
%_pam_modules_dir/pam_fprintd.so
%_man8dir/pam_fprintd.8*
%_sysconfdir/pam.d/system-auth-*

%files devel
%_datadir/dbus-1/interfaces/net.reactivated.Fprint.Device.xml
%_datadir/dbus-1/interfaces/net.reactivated.Fprint.Manager.xml

%files clients
%_bindir/%name-*

%changelog
