Summary: High-performance and highly configurable free RADIUS server
Name: freeradius
Version: 3.0.21
Release: alt1
License: GPLv2+ and LGPLv2+
Group: System/Servers
Url: http://www.freeradius.org/

# Cloned from git://git.freeradius.org/freeradius-server.git
Source0: %name-%version.tar
Source100: freeradius-radiusd-init
Source102: freeradius-logrotate
Source103: freeradius-pam-conf
Source104: freeradius-tmpfiles
Source105: freeradius-service

Patch1: %name-%version-%release.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libgdbm-devel
BuildRequires: libltdl-devel
BuildRequires: libcom_err-devel
BuildRequires: libstdc++-devel-static
BuildRequires: libmysqlclient-devel
BuildRequires: libldap-devel
BuildRequires: libpam-devel
BuildRequires: libreadline-devel
BuildRequires: libunixODBC-devel
BuildRequires: mailx
BuildRequires: net-snmp-utils
BuildRequires: perl-DBI perl-devel perl-DBM
BuildRequires: postgresql-devel
BuildRequires: python3-devel
BuildRequires: slocate
BuildRequires: libssl-devel openssl
BuildRequires: libtalloc-devel
BuildRequires: libkrb5-devel
BuildRequires: libpcre-devel
BuildRequires: libmemcached-devel
BuildRequires: libsasl2-devel
BuildRequires: libcurl-devel
BuildRequires: libjson-c-devel
BuildRequires: libsqlite3-devel
BuildRequires: libfreetds-devel
BuildRequires: libyubikey-devel
BuildRequires: libhiredis-devel
BuildRequires: libpcap-devel
BuildRequires: libcrypt-devel
BuildRequires: libsystemd-devel
BuildRequires: libwbclient-devel samba-devel

# in Sisyphus/autoimports
# BuildRequires: ykclient-devel

# hack
BuildRequires: chrpath
# Server needs dicts and /etc/raddb to work:
Requires: %name-common

%description
The FreeRADIUS Server Project is a high performance and highly configurable
GPL'd free RADIUS server. The server is similar in some respects to
Livingston's 2.0 server.  While FreeRADIUS started as a variant of the
Cistron RADIUS server, they don't share a lot in common any more. It now has
many more features than Cistron or Livingston, and is much more configurable.

FreeRADIUS is an Internet authentication daemon, which implements the RADIUS
protocol, as defined in RFC 2865 (and others). It allows Network Access
Servers (NAS boxes) to perform authentication for dial-up users. There are
also RADIUS clients available for Web servers, firewalls, Unix logins, and
more.  Using RADIUS allows authentication and authorization for a network to
be centralized, and minimizes the amount of re-configuration which has to be
done when adding or deleting new users.

%package common
Group: System/Servers
Summary: FreeRADIUS common data
# For now this subpackage contains only dicts (arch-independent):
BuildArch: noarch
# Alias for convience:
Provides: %name-dictionary = %version-%release

%description common
The FreeRADIUS common data

%package libs
Group: System/Servers
Summary: FreeRADIUS shared libraries

%description libs
The FreeRADIUS shared library

%package utils
Group: System/Servers
Summary: FreeRADIUS utilities
Requires: %name-libs = %version-%release
# Radius client(s) need dicts to work:
Requires: %name-dictionary = %version-%release

%description utils
The FreeRADIUS server has a number of features found in other servers,
and additional features not found in any other server. Rather than
doing a feature by feature comparison, we will simply list the features
of the server, and let you decide if they satisfy your needs.

Support for RFC and VSA Attributes Additional server configuration
attributes Selecting a particular configuration Authentication methods

%package devel
Group: Development/C
Summary: FreeRADIUS Development Files
Requires: %name-libs = %version-%release

%description devel
These are the static libraries for the FreeRADIUS package.

%package ldap
Summary: LDAP support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description ldap
This plugin provides the LDAP support for the FreeRADIUS server project.

%package krb5
Summary: Kerberos 5 support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description krb5
This plugin provides the Kerberos 5 support for the FreeRADIUS server project.

%package perl
Summary: Perl support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release


%description perl
This plugin provides the Perl support for the FreeRADIUS server project.

%package python3
Summary: Python3 support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description python3
This plugin provides the Python support for the FreeRADIUS server project.

%package mysql
Summary: MySQL support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description mysql
This plugin provides the MySQL support for the FreeRADIUS server project.

%package postgresql
Summary: postgresql support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description postgresql
This plugin provides the postgresql support for the FreeRADIUS server project.

%package sqlite
Summary: sqlite support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description sqlite
This plugin provides the sqlite support for the FreeRADIUS server project.

%package unixODBC
Summary: unixODBC support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description unixODBC
This plugin provides the unixODBC support for the FreeRADIUS server project.

%prep
%setup -q
%patch1 -p1

%build

# Hack: rlm_python3 as stable; prevents building other unstable modules.
sed 's/rlm_python/rlm_python3/g' src/modules/stable -i

export PY3_INC_DIR=%__python3_includedir

%autoreconf
# In order for the above hack to stick, do a fake configure so
# we can run reconfig before cleaning up after ourselves and running
# configure for real.
automake -a --force-missing --copy || true
./configure
make reconfig

%configure \
        --with-system-libtool \
        --with-system-libltdl \
        --localstatedir=/var \
        --libdir=%_libdir/freeradius \
        --disable-ltdl-install \
        --disable-static \
        --with-gnu-ld \
        --with-threads \
        --with-thread-pool \
        --with-systemd \
        --with-docdir=%_docdir/freeradius-%version \
        --with-rlm-sql_postgresql-include-dir=/usr/include/pgsql \
        --with-rlm-sql-postgresql-lib-dir=%_libdir \
        --with-rlm-sql_mysql-include-dir=/usr/include/mysql \
        --with-mysql-lib-dir=%_libdir/mysql \
        --with-unixodbc-lib-dir=%_libdir \
        --with-rlm-dbm-lib-dir=%_libdir \
        --with-rlm-krb5-include-dir=/usr/include/krb5 \
        --with-rlm_python3 \
        --with-rlm-python3-include-dir=$PY3_INC_DIR \
        --without-rlm_eap_ikev2 \
        --without-rlm_eap_tnc \
        --without-rlm_sql_iodbc \
        --without-rlm_sql_firebird \
        --without-rlm_sql_db2 \
        --without-rlm_sql_oracle

%make_build

%install
make install R=%buildroot

# modify default configuration
RADDB=%buildroot%_sysconfdir/raddb
sed -i 's/^#user =.*$/user = radiusd/'   $RADDB/radiusd.conf
sed -i 's/^#group =.*$/group = radiusd/' $RADDB/radiusd.conf
# logs
mkdir -p %buildroot%_logdir/radius/radacct
touch %buildroot%_logdir/radius/{radutmp,radius.log}

mkdir -p %buildroot%_runtimedir/radiusd
mkdir -p %buildroot%_sysconfdir/{logrotate.d,pam.d,rc.d/init.d}
mkdir -p %buildroot%_tmpfilesdir
mkdir -p %buildroot%_unitdir
mkdir -p %buildroot%_localstatedir/radiusd
install -m 755 %SOURCE100 %buildroot%_initdir/radiusd
install -m 644 %SOURCE102 %buildroot%_sysconfdir/logrotate.d/radiusd
install -m 644 %SOURCE103 %buildroot%_sysconfdir/pam.d/radiusd
install -m 644 %SOURCE104 %buildroot%_tmpfilesdir/radiusd.conf
install -m 644 %SOURCE105 %buildroot%_unitdir/radiusd.service

# remove unneeded stuff
rm -f %buildroot%_sbindir/rc.radiusd
rm -f %buildroot%_bindir/rbmonkey
rm -f %buildroot%_libdir/freeradius/*.a
rm -f %buildroot%_libdir/freeradius/*.la
rm -rf %buildroot%_sysconfdir/raddb/mods-config/sql/main/mssql
rm -rf %buildroot%_sysconfdir/raddb/mods-config/sql/ippool/mssql
rm -rf %buildroot%_sysconfdir/raddb/mods-config/sql/main/oracle
rm -rf %buildroot%_sysconfdir/raddb/mods-config/sql/ippool-dhcp/oracle
rm -rf %buildroot%_sysconfdir/raddb/mods-config/sql/ippool/oracle
rm -rf %buildroot%_sysconfdir/raddb/mods-config/sql/ippool/mongo
rm -rf %buildroot%_sysconfdir/raddb/mods-config/sql/main/mongo

rm -f %buildroot%_sysconfdir/raddb/certs/*.crt
rm -f %buildroot%_sysconfdir/raddb/certs/*.crl
rm -f %buildroot%_sysconfdir/raddb/certs/*.csr
rm -f %buildroot%_sysconfdir/raddb/certs/*.der
rm -f %buildroot%_sysconfdir/raddb/certs/*.key
rm -f %buildroot%_sysconfdir/raddb/certs/*.pem
rm -f %buildroot%_sysconfdir/raddb/certs/*.p12
rm -f %buildroot%_sysconfdir/raddb/certs/index.*
rm -f %buildroot%_sysconfdir/raddb/certs/serial*
rm -f %buildroot%_sysconfdir/raddb/certs/dh
rm -f %buildroot%_sysconfdir/raddb/certs/random

rm -f %buildroot%_sysconfdir/raddb/mods-available/unbound
rm -rf %buildroot%_sysconfdir/raddb/mods-config/unbound
rm -f %buildroot%_sysconfdir/raddb/mods-available/couchbase
rm -f %buildroot%_sysconfdir/raddb/mods-available/abfab*
rm -f %buildroot%_sysconfdir/raddb/mods-available/moonshot-targeted-ids
rm -f %buildroot%_sysconfdir/raddb/policy.d/abfab*
rm -f %buildroot%_sysconfdir/raddb/policy.d/moonshot-targeted-ids
rm -f %buildroot%_sysconfdir/raddb/sites-available/abfab*
rm -f %buildroot%_sysconfdir/raddb/mods-available/python

rm -f %buildroot%_libdir/freeradius/rlm_test.so

# remove unsupported config files
rm -f %buildroot%_sysconfdir/raddb/experimental.conf

# rpath hack: RPATH contains standard library path "/usr/lib64": /usr/lib64
chrpath -d %buildroot%_libdir/freeradius/rlm_sql_postgresql.so
chrpath -d %buildroot%_libdir/freeradius/rlm_sql_unixodbc.so

%pre common
/usr/sbin/groupadd -r -f radiusd
/usr/sbin/useradd -r -n -g radiusd -d /dev/null -s /dev/null -c RADIUS radiusd >/dev/null 2>&1 ||:

%post
%post_service radiusd
if [ $1 = 1 ]; then
    if [ ! -e /etc/raddb/certs/server.pem ]; then
        su -s "/bin/sh" -c "/etc/raddb/certs/bootstrap" radiusd > /dev/null 2>&1 || :
    fi
fi

%preun
%preun_service radiusd

%files
%doc %_docdir/freeradius-%version/
%config(noreplace) %_sysconfdir/pam.d/radiusd
%config(noreplace) %_sysconfdir/logrotate.d/radiusd
%config(noreplace) %_initdir/radiusd
%_unitdir/radiusd.service
%_tmpfilesdir/radiusd.conf
%dir %attr(775,root,radiusd) %_localstatedir/radiusd
# configs
%defattr(-,root,radiusd)
#%config(noreplace) %_sysconfdir/raddb/acct_users
#%config(noreplace) %_sysconfdir/raddb/attrs
#%config(noreplace) %_sysconfdir/raddb/attrs.access_challenge
#%config(noreplace) %_sysconfdir/raddb/attrs.access_reject
#%config(noreplace) %_sysconfdir/raddb/attrs.accounting_response
#%config(noreplace) %_sysconfdir/raddb/attrs.pre-proxy
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/clients.conf
%config(noreplace) %_sysconfdir/raddb/hints
%config(noreplace) %_sysconfdir/raddb/huntgroups
#%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sqlippool.conf
#%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/preproxy_users
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/proxy.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/radiusd.conf
#%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sql.conf
#%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/users
%dir %attr(770,root,radiusd) %_sysconfdir/raddb/certs
%_sysconfdir/raddb/certs/Makefile
%_sysconfdir/raddb/certs/README
%_sysconfdir/raddb/certs/xpextensions
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/certs/*.cnf
%attr(750,root,radiusd) %_sysconfdir/raddb/certs/bootstrap
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sites-available
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sites-available/*
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sites-enabled
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sites-enabled/*
#%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/eap.conf
#%attr(640,root,radiusd) %_sysconfdir/raddb/example.pl
#%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.conf
#%_sysconfdir/raddb/policy.txt
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/templates.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/trigger.conf

## ---- TODO -- new ---------------------------------------------
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/README.rst
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/certs/passwords.mk
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/panic.gdb
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/accounting
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/canonicalization
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/control
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/cui
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/debug
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/dhcp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/eap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/filter
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/operator-name
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.d/rfc7542
## ---- END -- new ---------------------------------------------


%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-available
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-enabled
%_sysconfdir/raddb/mods-available/README.rst
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/always
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/attr_filter
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/cache
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/cache_eap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/chap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/counter
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/cui
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/date
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/detail
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/detail.example.com
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/detail.log
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/dhcp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/dhcp_sqlippool
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/digest
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/dynamic_clients
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/eap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/echo
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/etc_group
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/exec
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/expiration
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/expr
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/files
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/idn
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/inner-eap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/ippool
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/ldap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/linelog
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/logintime
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/mac2ip
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/mac2vlan
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/mschap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/ntlm_auth
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/opendirectory
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/otp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/pam
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/pap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/passwd
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/preprocess
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/radutmp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/realm
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/redis
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/rediswho
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/replicate
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/rest
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/smbpasswd
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/smsotp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/soh
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/sometimes
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/sqlcounter
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/sqlippool
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/sradutmp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/unix
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/unpack
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/utf8
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/wimax
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/yubikey
%_sysconfdir/raddb/mods-config/README.rst
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/attr_filter
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/attr_filter/access_challenge
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/attr_filter/access_reject
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/attr_filter/accounting_response
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/attr_filter/post-proxy
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/attr_filter/pre-proxy
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/files
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/files/accounting
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/files/authorize
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/files/pre-proxy
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/preprocess
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/preprocess/hints
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/preprocess/huntgroups
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/counter
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/cui
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/ippool
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/ippool-dhcp
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/main
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids

%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/always
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/attr_filter
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/cache_eap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/chap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/date
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/detail
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/detail.log
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/digest
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/dynamic_clients
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/eap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/echo
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/exec
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/expiration
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/expr
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/files
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/linelog
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/logintime
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/mschap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/ntlm_auth
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/pap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/passwd
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/preprocess
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/radutmp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/realm
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/replicate
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/soh
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/sradutmp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/unix
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/unpack
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-enabled/utf8


%dir %attr(770,root,radiusd) %_runtimedir/radiusd/

%defattr(-,root,root)
# binaries
%_sbindir/checkrad
%_sbindir/raddebug
%_sbindir/radiusd
#%_sbindir/radwatch
%_sbindir/radmin
# man-pages
%_man1dir/*
%_man5dir/*
%_man8dir/*
# logs
%dir %attr(1770,root,radiusd) %_logdir/radius/
%dir %attr(1770,root,radiusd) %_logdir/radius/radacct/
%config(noreplace) %attr(664,root,radiusd) %_logdir/radius/radutmp
%config(noreplace) %attr(660,radiusd,radiusd) %_logdir/radius/radius.log
# RADIUS Loadable Modules
%dir %_libdir/freeradius
%_libdir/freeradius/proto_dhcp.so
%_libdir/freeradius/proto_vmps.so
%_libdir/freeradius/rlm_always.so
%_libdir/freeradius/rlm_attr_filter.so
%_libdir/freeradius/rlm_cache.so
%_libdir/freeradius/rlm_cache_rbtree.so
%_libdir/freeradius/rlm_chap.so
%_libdir/freeradius/rlm_counter.so
%_libdir/freeradius/rlm_cram.so
%_libdir/freeradius/rlm_date.so
%_libdir/freeradius/rlm_detail.so
%_libdir/freeradius/rlm_dhcp.so
%_libdir/freeradius/rlm_digest.so
%_libdir/freeradius/rlm_dynamic_clients.so
%_libdir/freeradius/rlm_eap.so
%_libdir/freeradius/rlm_eap_fast.so
%_libdir/freeradius/rlm_eap_gtc.so
%_libdir/freeradius/rlm_eap_leap.so
%_libdir/freeradius/rlm_eap_md5.so
%_libdir/freeradius/rlm_eap_mschapv2.so
%_libdir/freeradius/rlm_eap_peap.so
%_libdir/freeradius/rlm_eap_pwd.so
%_libdir/freeradius/rlm_eap_sim.so
%_libdir/freeradius/rlm_eap_tls.so
%_libdir/freeradius/rlm_eap_ttls.so
%_libdir/freeradius/rlm_exec.so
%_libdir/freeradius/rlm_expiration.so
%_libdir/freeradius/rlm_expr.so
%_libdir/freeradius/rlm_files.so
%_libdir/freeradius/rlm_ippool.so
%_libdir/freeradius/rlm_linelog.so
%_libdir/freeradius/rlm_logintime.so
%_libdir/freeradius/rlm_mschap.so
%_libdir/freeradius/rlm_otp.so
%_libdir/freeradius/rlm_pam.so
%_libdir/freeradius/rlm_pap.so
%_libdir/freeradius/rlm_passwd.so
%_libdir/freeradius/rlm_preprocess.so
%_libdir/freeradius/rlm_radutmp.so
%_libdir/freeradius/rlm_realm.so
%_libdir/freeradius/rlm_replicate.so
%_libdir/freeradius/rlm_soh.so
%_libdir/freeradius/rlm_sometimes.so
%_libdir/freeradius/rlm_sql.so
%_libdir/freeradius/rlm_sql_null.so
%_libdir/freeradius/rlm_sqlcounter.so
%_libdir/freeradius/rlm_sqlippool.so
%_libdir/freeradius/rlm_unix.so
%_libdir/freeradius/rlm_unpack.so
%_libdir/freeradius/rlm_utf8.so
%_libdir/freeradius/rlm_wimax.so
%_libdir/freeradius/rlm_yubikey.so

# todo: move to subpackages?
%_libdir/freeradius/rlm_cache_memcached.so
%_libdir/freeradius/rlm_redis.so
%_libdir/freeradius/rlm_rediswho.so
%_libdir/freeradius/rlm_rest.so
%_libdir/freeradius/rlm_sql_freetds.so

%files common
%dir %attr(755,root,radiusd) %_sysconfdir/raddb
%attr(644,root,root) %config(noreplace) %_sysconfdir/raddb/dictionary
# dictionaries
%_datadir/freeradius

%files utils
%_bindir/*

%files libs
# RADIU shared libs
%_libdir/freeradius/lib*.so*

%files devel
%_includedir/freeradius

%files krb5
%_libdir/freeradius/rlm_krb5.so
#%_libdir/freeradius/rlm_krb5-%version.so
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/krb5


%files perl
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/perl
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/perl
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/perl/example.pl
%_libdir/freeradius/rlm_perl.so
#%_libdir/freeradius/rlm_perl-%version.so

%files python3
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-available/python3
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/python3
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/python3/example.py
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/python3/radiusd.py
%_libdir/freeradius/rlm_python3.so
#%_libdir/freeradius/rlm_python3-%version.so

%files mysql
%_libdir/freeradius/rlm_sql_mysql.so
#%_libdir/freeradius/rlm_sql_mysql-%version.so
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/mysql/dailycounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/mysql/expire_on_login.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/mysql/monthlycounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/mysql/noresetcounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/cui/mysql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/cui/mysql/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool-dhcp/mysql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool-dhcp/mysql/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool/mysql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool/mysql/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool/mysql/procedure.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/mysql/extras/wimax/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/mysql/extras/wimax/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/mysql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/mysql/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/mysql/setup.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/mysql/process-radacct.sql
%_sysconfdir/raddb/mods-config/sql/main/ndb/README
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/ndb/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/ndb/setup.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids/mysql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids/mysql/schema.sql

%files postgresql
%_libdir/freeradius/rlm_sql_postgresql.so
#%_libdir/freeradius/rlm_sql_postgresql-%version.so
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/counter/postgresql
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/cui/postgresql
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/ippool/postgresql
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/main/postgresql
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/main/postgresql/extras
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids/postgresql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/postgresql/dailycounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/postgresql/expire_on_login.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/postgresql/monthlycounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/postgresql/noresetcounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/cui/postgresql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/cui/postgresql/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool/postgresql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool/postgresql/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool/postgresql/procedure.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/postgresql/extras/cisco_h323_db_schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/postgresql/extras/voip-postpaid.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/postgresql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/postgresql/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/postgresql/setup.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/postgresql/process-radacct.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids/postgresql/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids/postgresql/schema.sql

%files sqlite
%_libdir/freeradius/rlm_sql_sqlite.so
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/counter/sqlite
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/cui/sqlite
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/ippool-dhcp/sqlite
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/ippool/sqlite
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/main/sqlite
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids/sqlite
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/sqlite/dailycounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/sqlite/expire_on_login.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/sqlite/monthlycounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/counter/sqlite/noresetcounter.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/cui/sqlite/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/cui/sqlite/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool-dhcp/sqlite/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool-dhcp/sqlite/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool/sqlite/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/ippool/sqlite/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/sqlite/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/sqlite/schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/sqlite/process-radacct-refresh.sh
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/main/sqlite/process-radacct-schema.sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids/sqlite/queries.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/mods-config/sql/moonshot-targeted-ids/sqlite/schema.sql

%files ldap
#%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/ldap.attrmap
%_libdir/freeradius/rlm_ldap.so
#%_libdir/freeradius/rlm_ldap-%version.so
#%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/ldap

%files unixODBC
%_libdir/freeradius/rlm_sql_unixodbc.so
#%_libdir/freeradius/rlm_sql_unixodbc-%version.so

%changelog
