%def_with opencv

%define bname frei0r
%define major_ver 1
%define minor_ver 7

Name: %bname-plugins
Version: %major_ver.%minor_ver.0
Release: alt2

Summary: Frei0r - a minimalistic plugin API for video effects
License: GPL-2.0+
Group: Video

Url: https://frei0r.dyne.org
# git https://github.com/dyne/frei0r.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++
BuildRequires: libgavl-devel >= 0.2.3
BuildRequires: doxygen fonts-ttf-dejavu graphviz
BuildRequires: libcairo-devel >= 1.0.0
%{?_with_opencv:BuildRequires: libopencv-devel}

%description
It is a minimalistic plugin API for video sources and filters. The behaviour of
the effects can be controlled from the host by simple parameters. The intent is
to solve the recurring reimplementation or adaptation issue of standard effect

%package -n frei0r-devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description -n frei0r-devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n frei0r-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description -n frei0r-devel-doc
This package contains development documentation for %name

%package facedetect
Summary: Face detect plugin for %name
Group: Video
Requires: %name = %version-%release
Requires: libopencv-utils

%description facedetect
Face detect plugin for %name

%prep
%setup
%patch -p1

%build
# hack for compilation with opencv4 support
%add_optflags $(pkg-config --cflags opencv4)

mkdir -p m4
%autoreconf
%configure --disable-static

# workaround cvconfig.h
ln -s config.h include/cvconfig.h

%make_build

%install
%makeinstall_std

%files
%dir %_libdir/%bname-%major_ver
%_libdir/%bname-%major_ver/*.so
%if_with opencv
%exclude %_libdir/%bname-%major_ver/facebl0r.so
%exclude %_libdir/%bname-%major_ver/facedetect.so
%endif

%files -n frei0r-devel
%_includedir/frei0r.h
%_pkgconfigdir/*.pc

%files -n frei0r-devel-doc
%_defaultdocdir/%name/*

%if_with opencv
%files facedetect
%_libdir/%bname-%major_ver/facebl0r.so
%_libdir/%bname-%major_ver/facedetect.so
%endif

%changelog
