%global appid org.gajim.Gajim

# reduce an amount of overabundant dependencies
%filter_from_requires /^python3(gajim.gui/d

Name: gajim
Version: 1.4.7
Release: alt0.p10.1

Summary: a Jabber client written in PyGTK
License: GPL-3.0-only
Group: Networking/Instant messaging
Url: http://gajim.org
Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: https://gajim.org/downloads/1.3/gajim-%version.tar.gz
Patch1: gajim-1.2.2-alt-fix-egg-requires.patch

# minimal python version for gajim >= 1.2.2
Requires: python3 >= 3.7

# typelib(Avahi)
%filter_from_requires /^typelib(Avahi)/d

Requires: libgtk+3-gir libsoup-gir libgtksourceview4-gir
%py3_requires cssutils
%py3_requires keyring
%py3_requires precis_i18n
%py3_requires nbxmpp
%py3_requires precis_i18n
%py3_requires OpenSSL
%py3_requires cairo

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: libgtk+3-devel python3-devel python3-module-setuptools libsoup-gir-devel libgtksourceview4-gir-devel
BuildRequires: python3-module-nbxmpp >= 3.0.2
BuildArch: noarch

%description
Gajim is a Jabber client written in PyGTK. The goal of Gajim's developers
is to provide a full featured and easy to use xmpp client for the GTK+
users. Gajim does not require GNOME to run, eventhough it exists with
it nicely.

%prep
%setup -n %name-%version
#patch1 -p1

%build
%python3_build

%install
%python3_install

%find_lang %name

%files -f %name.lang
#doc AUTHORS ChangeLog README THANKS
%_bindir/%name
%_bindir/%name-remote
#_bindir/%name-history-manager
%_man1dir/*
%_datadir/applications/%appid.desktop
%_datadir/metainfo/%appid.appdata.xml
%_datadir/icons/hicolor/scalable/apps/%appid.svg
%_datadir/icons/hicolor/scalable/apps/%appid-symbolic.svg
%python3_sitelibdir/%name
%python3_sitelibdir/%name-%{version}*.egg-info

#_desktopdir/%name.desktop
#_desktopdir/%name-remote.desktop
#_iconsdir/hicolor/scalable/apps/%name.svg
#_iconsdir/hicolor/64x64/apps/%name.png
#_iconsdir/hicolor/128x128/apps/%name.png

%changelog
