Name: gambit
Version: 4.9.3
Release: alt2

Summary: Gambit-C Scheme programming system
License: Apache-2.0
Group: Development/Other
URL: http://www.iro.umontreal.ca/~gambit/
Conflicts: ghostscript-minimal < 8.64-alt5

Packager: Paul Wolneykien <manowar@altlinux.org>

Source: %name-%version.tar
Patch: gambit-4.9.1-alt-e2k-lcc123.patch

%ifarch %e2k
%def_without emacs
%else
%def_with emacs
%endif

%if_with emacs
BuildRequires: emacs-nox
%endif
BuildRequires: makeinfo
BuildPreReq: alternatives

%description
Gambit-C includes a Scheme interpreter and a Scheme compiler which can be used
to build standalone executables. Because the compiler generates portable C
code it is fairly easy to port to any platform with a decent C compiler.

The Gambit-C system conforms to the R4RS and IEEE Scheme standards.  The full
numeric tower is implemented, including: infinite precision integers (bignums),
rationals, inexact reals (floating point numbers), and complex numbers.

%if_with emacs
%package -n emacs-gambit
Summary: Emacs mode for Gambit-C
Group: Editors
Requires: gambit emacs-common
BuildArch: noarch

%description -n emacs-gambit
Emacs mode for running Gambit-C
%endif

%package docs
Summary: Gambit-C manuals ang examples
Group: Development/Documentation
Requires: gambit = %version-%release
BuildArch: noarch

%description docs
Gambit-C manuals ang examples

%package info
Summary: Gambit-C manual in info format
Group: Development/Documentation
Requires: gambit = %version-%release
BuildArch: noarch

%description info
Gambit-C manual in info format

%package devel
Summary: Development files for Gambit-C Scheme
Group: Development/Other
Requires: gambit = %version-%release

%description devel
Development files for Gambit-C Scheme

%package devel-java
Summary: Development files for Gambit Scheme (Java backend)
Group: Development/Other
Requires: gambit = %version-%release

%description devel-java
Development files for Gambit Scheme (Java backend)

%package devel-php
Summary: Development files for Gambit Scheme (PHP backend)
Group: Development/Other
Requires: gambit = %version-%release
Requires: /usr/bin/php

%description devel-php
Development files for Gambit Scheme (PHP backend)

%package devel-python
Summary: Development files for Gambit Scheme (Python backend)
Group: Development/Other
Requires: gambit = %version-%release
Requires: /usr/bin/python3

%description devel-python
Development files for Gambit Scheme (Python backend)

%package devel-js
Summary: Development files for Gambit Scheme (JavaScript backend)
Group: Development/Other
Requires: gambit = %version-%release
Requires: /usr/bin/node

%description devel-js
Development files for Gambit Scheme (JavaScript backend)

%package devel-ruby
Summary: Development files for Gambit Scheme (Ruby backend)
Group: Development/Other
Requires: gambit = %version-%release
Requires: /usr/bin/ruby

%description devel-ruby
Development files for Gambit Scheme (Ruby backend)

# See GAMBCDIR_LIB (doesn't work, TODO)
#define _libdir %_prefix/%_lib/gambit
%define pkgdocdir %_docdir/%name-%version

%prep
%setup
%patch -p2

%build
%ifarch %e2k
%add_optflags -D___LITTLE_ENDIAN
%endif
%configure --enable-single-host --enable-shared \
	   --disable-absolute-shared-libs \
	   --docdir=%pkgdocdir
%make_build

%if_with emacs
emacs -q -no-site-file -batch -eval "(byte-compile-file \"misc/gambit.el\")"
%endif

%install
%makeinstall_std
for f in $RPM_BUILD_ROOT%_bindir/scheme-*; do
    mv $f $f-%name
done

cp -R examples/* %buildroot%pkgdocdir/
rm -f %buildroot%pkgdocdir/makefile*
rm -f %buildroot%pkgdocdir/*/makefile*

%if_with emacs
install -m644 misc/*.el* %buildroot%_emacslispdir/
%endif

install -d $RPM_BUILD_ROOT%_altdir
cat > $RPM_BUILD_ROOT%_altdir/%name <<EOF
%_bindir/scheme-r5rs		%_bindir/scheme-r5rs-gambit		10
%_bindir/scheme-r4rs		%_bindir/scheme-r4rs-gambit		10
%_bindir/scheme-srfi-0		%_bindir/scheme-srfi-0-gambit		10
%_bindir/scheme-ieee-1178-1990	%_bindir/scheme-ieee-1178-1990-gambit	10
EOF

%check
%make check

%files
%_altdir/*
%_bindir/*-%name
%_bindir/gsc*
%_bindir/gsi*
%_bindir/six*
%_includedir/*.h
%_libdir/*.so*
%_man1dir/*.1.*

%if_with emacs
%files -n emacs-gambit
%_emacslispdir/*
%endif

%files docs
%pkgdocdir/

%files info
%_infodir/*.info*

%files devel
%_bindir/gambcomp-C
%_libdir/*.scm
%_libdir/_*.c

%files devel-java
%_bindir/gambcomp-java

%files devel-js
%_bindir/gambcomp-js

%files devel-php
%_bindir/gambcomp-php

%files devel-python
%_bindir/gambcomp-python

%files devel-ruby
%_bindir/gambcomp-ruby

%changelog
