%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 3.40
%def_enable introspection
%def_enable gtk_doc
%def_enable check

Name: gcr
Version: %ver_major.0
Release: alt1

Summary: A GNOME crypto viewer and prompter
Group: Graphical desktop/GNOME
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/GnomeKeyring

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: %name-libs = %version-%release
Requires: libtasn1-utils
Conflicts: gnome-keyring < 3.3.0

%define glib_ver 2.44.0
%define gtk_ver 3.22
%define p11kit_ver 0.19.0
%define vala_ver 0.18.1
%define gcrypt_ver 1.4.5

BuildRequires(pre): meson rpm-build-gir
BuildRequires: gtk-doc python3 glib2-devel >= %glib_ver
BuildRequires: libp11-kit-devel >= %p11kit_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libgcrypt-devel >= %gcrypt_ver libtasn1-devel libtasn1-utils libtasn1-utils gnupg2-gpg
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}
BuildRequires: libvala-devel >= %vala_ver vala-tools
%{?_enable_check:BuildRequires: /proc xvfb-run dbus-tools-gui %_bindir/ssh-keygen}

%description
GCR is a library for displaying certificates, and crypto UI, accessing
key stores. It also provides the viewer for crypto files on the GNOME
desktop.

GCK is a library for accessing PKCS#11 modules like smart cards, in a
(G)object oriented way.

%package libs
Summary: Development files for GCR
Group: System/Libraries
Obsoletes: gnome-keyring-libs < 3.3.0
Provides: gnome-keyring-libs = %version-%release

%description libs
GCR is a library for displaying certificates, and crypto UI, accessing
key stores. It also provides the viewer for crypto files on the GNOME
desktop.

GCK is a library for accessing PKCS#11 modules like smart cards, in a
(G)object oriented way.

%package libs-devel
Summary: Development files for GCR
Group: Development/C
Obsoletes: gnome-keyring-libs-devel < 3.3.0
Provides: gnome-keyring-libs-devel = %version-%release
Requires: %name-libs = %version-%release

%description libs-devel
The gcr-devel package includes the header files for the GCR libraries.

%package libs-gir
Summary: GObject introspection data for GCR libraries
Group: System/Libraries
Requires: %name-libs = %version-%release

%description libs-gir
GObject introspection data for GCR libraries.

%package libs-gir-devel
Summary: GObject introspection devel data for the GCR libraries
Group: System/Libraries
BuildArch: noarch
Requires: %name-libs-gir = %version-%release
Requires: %name-libs-devel = %version-%release

%description libs-gir-devel
GObject introspection devel data for the GCR libraries.

%package libs-vala
Summary: Vala language bindings for the GCR libraries
Group: Development/Other
BuildArch: noarch
Requires: %name-libs = %version-%release

%description libs-vala
This package provides Vala language bindings for the GCR libraries.

%package libs-devel-doc
Summary: Development documentation for GCR libraries
Group: Development/Documentation
Conflicts: %name-libs < %version-%release
BuildArch: noarch

%description libs-devel-doc
This package contains development documentation for GCR libraries.


%prep
%setup

%build
%meson \
%{?_disable_introspection:-Dintrospection=false} \
%{?_disable_gtk_doc:-Dgtk_doc=false}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
xvfb-run %meson_test

%files -f %name.lang
%_bindir/gcr-viewer
%_libexecdir/gcr-prompter
%_libexecdir/gcr-ssh-askpass
%_datadir/applications/gcr-viewer.desktop
%_datadir/applications/gcr-prompter.desktop
%dir %_datadir/GConf
%dir %_datadir/GConf/gsettings
%_datadir/GConf/gsettings/org.gnome.crypto.pgp.convert
%_datadir/GConf/gsettings/org.gnome.crypto.pgp_keyservers.convert
%_datadir/glib-2.0/schemas/org.gnome.crypto.pgp.gschema.xml
%_datadir/icons/hicolor/*/apps/*
%_datadir/mime/packages/gcr-crypto-types.xml
%_datadir/dbus-1/services/org.gnome.keyring.PrivatePrompter.service
%_datadir/dbus-1/services/org.gnome.keyring.SystemPrompter.service

%files libs
%_libdir/libgck-1.so.*
%_libdir/libgcr-base-3.so.*
%_libdir/libgcr-ui-3.so.*

%files libs-devel
%_includedir/gck-1
%_includedir/gcr-3
%_libdir/libgck-1.so
%_libdir/libgcr-base-3.so
%_libdir/libgcr-ui-3.so
%_pkgconfigdir/gck-1.pc
%_pkgconfigdir/gcr-3.pc
%_pkgconfigdir/gcr-base-3.pc
%_pkgconfigdir/gcr-ui-3.pc

%if_enabled gtk_doc
%files libs-devel-doc
%_datadir/gtk-doc/html/gck/
%_datadir/gtk-doc/html/gcr/
%endif

%if_enabled introspection
%files libs-gir
%_typelibdir/Gck-1.typelib
%_typelibdir/Gcr-3.typelib
%_typelibdir/GcrUi-3.typelib

%files libs-gir-devel
%_girdir/Gck-1.gir
%_girdir/Gcr-3.gir
%_girdir/GcrUi-3.gir
%endif

%files libs-vala
%_vapidir/gck-1.deps
%_vapidir/gck-1.vapi
%_vapidir/gcr-3.deps
%_vapidir/gcr-3.vapi
%_vapidir/gcr-ui-3.deps
%_vapidir/gcr-ui-3.vapi
%_vapidir/pkcs11.vapi


%changelog
