%def_disable snapshot

%define ver_major 40
%define beta %nil
%define api_ver 1.0

%define _libexecdir %_prefix/libexec
%define _localstatedir %_var
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)

%define default_pam_config redhat
# Initial virtual terminal to use
%define vt_nr 1

%def_disable static
%def_disable debug
%def_enable ipv6
%def_with xdmcp
%def_with selinux
%def_with libaudit
%def_without plymouth
%def_enable wayland
%def_enable xsession
#Enable running X server as user
%def_enable user_display_server
%def_enable check

Name: gdm
Version: %ver_major.1
Release: alt2%beta

Summary: The GNOME Display Manager
License: GPL-2.0
URL: http://wiki.gnome.org/Projects/GDM
Group: Graphical desktop/GNOME

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

Source1: gdm_xdmcp.control
Source2: gdm.wms-method
Source3: default.pa-for-gdm

# PAM config files
Source10: gdm.pam
Source11: gdm-autologin.pam
Source12: gdm-password.pam
Source13: gdm-launch-environment.pam
Source14: gdm-smartcard.pam
Source15: gdm-fingerprint.pam

Patch2: gdm-40.beta-alt-Xsession.patch
Patch7: gdm-40.beta-alt-Init.patch

Obsoletes: %name-gnome
Provides: %name-gnome = %version-%release
Provides: gnome-dm

# from configure.ac
%define glib_ver 2.36.0
%define gtk_ver 3.16.0
%define shell_ver %ver_major
%define libcanberra_ver 0.4
%define accountsservice_ver 0.6.35
%define check_ver 0.9.4

Provides: %name-user-switch-applet = %version-%release
Obsoletes: %name-user-switch-applet

Requires(pre): %_rpmlibdir/update-dconf-database.filetrigger
Requires: %name-libs = %version-%release
Requires(pre): %name-data = %version-%release
Requires(pre): gnome-shell >= %shell_ver
Requires: accountsservice >= %accountsservice_ver
Requires: coreutils xinitrc iso-codes lsb-release shadow-utils
Requires: gnome-session >= %ver_major
Requires: gnome-session-wayland
Requires: /bin/dbus-run-session

BuildRequires(pre): meson rpm-build-gnome rpm-build-gir rpm-macros-pam0
BuildRequires: gcc-c++ desktop-file-utils gnome-common yelp-tools
BuildRequires: iso-codes-devel
BuildRequires: glib2-devel >= %glib_ver libgio-devel
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libaccountsservice-devel >= %accountsservice_ver
BuildRequires: dconf pkgconfig(systemd) libpam-devel
%{?_with_selinux:BuildPreReq: libselinux-devel libattr-devel}
%{?_with_libaudit:BuildPreReq: libaudit-devel}
%{?_with_plymouth:BuildPreReq: plymouth-devel}
BuildRequires: libcanberra-devel >= %libcanberra_ver libcanberra-gtk3-devel
BuildRequires: libXdmcp-devel

BuildRequires: libX11-devel libXau-devel libXrandr-devel libXext-devel libXft-devel libSM-devel
BuildRequires: libXi-devel xorg-proto-devel libXinerama-devel
BuildRequires: xorg-xephyr xorg-server
BuildRequires: libkeyutils-devel
BuildRequires: libcheck-devel >= %check_ver

BuildRequires: libdmx-devel
BuildRequires: librsvg-devel perl-XML-Parser docbook-dtds xsltproc zenity
BuildRequires: gobject-introspection-devel
BuildRequires: libdaemon-devel libudev-devel
%{?_enable_check:BuildRequires: /proc dbus-tools-gui}

%description
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

%package data
Summary: Arch independent files for GDM
Group: Graphical desktop/GNOME
BuildArch: noarch
Conflicts: gdm2.20

%description data
This package provides noarch data needed for GDM to work.

%package libs
Summary: GDM libraries
Group: System/Libraries

%description -n %name-libs
This package contains shared libraries needed for GNOME Display Manager
to work.

%package libs-devel
Summary: Development files for GDM libraries
Group: Development/C
Requires: %name-libs = %version-%release

%description libs-devel
This package contains headers and development libraries for GNOME
Display Manager.

%package libs-gir
Summary: GObject introspection data for the GDM
Group: System/Libraries
Requires: %name-libs = %version-%release

%description libs-gir
GObject introspection data for the GDM libraries.

%package libs-gir-devel
Summary: GObject introspection devel data for the GDM
Group: Development/Other
BuildArch: noarch
Requires: %name-libs-gir = %version-%release
Requires: %name-libs-devel = %version-%release

%description libs-gir-devel
GObject introspection devel data for the GDM libraries.

%package help
Summary: User documentation for Gdm
Group: Graphical desktop/GNOME
BuildArch: noarch
Conflicts: %name < %version-%release

%description help
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

This package contains user documentation for Gdm.

%prep
%setup -n %name-%version%beta
%patch2 -p1 -b .XSession
%patch7 -p1 -b .Init

# just copy our PAM config files to %default_pam_config directory
cp %SOURCE10 %SOURCE11 %SOURCE12 %SOURCE13 %SOURCE14 %SOURCE15  data/pam-%default_pam_config/

%build
%meson \
	%{?_enable_ipv6:-Dipv6=true} \
	-Dinitial-vt='%vt_nr' \
	-Ddefault-path='/bin:/usr/bin:/usr/local/bin' \
	-Dsysconfsubdir='X11/gdm' \
	-Dpam-prefix='%_sysconfdir' \
	-Dpam-mod-dir='%_pam_modules_dir' \
	-Ddefault-pam-config='%default_pam_config' \
	-Ddmconfdir='%_sysconfdir/X11/sessions' \
	-Dudev-dir='%_udevrulesdir' \
	%{?_without_xdmcp:-Dxdmcp=disabled} \
	%{?_without_libaudit:-Dlibaudit=disabled} \
	%{?_without plymouth:-Dplymouth=disabled} \
	%{?_disable_wayland:-Dwayland-support=false} \
	%{?_enable_xsession:-Dgdm-xsession=true} \
	%{?_disable_user_display_server:-Duser-display-server=false}
%nil
%meson_build

%install
mkdir -p %buildroot%_sysconfdir/X11/sessions
mkdir -p %buildroot%_sysconfdir/X11/wms-methods.d

%meson_install
rm -f %buildroot%_sysconfdir/pam.d/gdm

# env.d directories
mkdir -p %buildroot{%_sysconfdir/X11,%_datadir}/gdm/env.d

# install external hook for update_wms
install -m755 %SOURCE2 %buildroot%_sysconfdir/X11/wms-methods.d/%name

# control gdm/xdmcp
install -pDm755 %SOURCE1 %buildroot%_controldir/gdm_xdmcp

# default.pa for gdm
install -p -m644 -D %SOURCE3 %buildroot%_localstatedir/lib/gdm/.config/pulse/default.pa

%find_lang %name
%find_lang --output=%name-help.lang --without-mo --with-gnome %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
dbus-run-session %meson_test

%pre
%pre_control gdm_xdmcp

%post
%post_control -s disabled gdm_xdmcp

%files
%_sbindir/gdm
%_bindir/gdm-screenshot
%_bindir/gdmflexiserver
%_libexecdir/gdm-host-chooser
%_libexecdir/gdm-session-worker
%_libexecdir/gdm-simple-chooser
%_libexecdir/gdm-wayland-session
%_libexecdir/gdm-x-session
%_libexecdir/gdm-runtime-config
%_pam_modules_dir/pam_gdm.so
%_unitdir/gdm.service
%_userunitdir/gnome-session@gnome-login.target.d/session.conf
%doc AUTHORS NEWS README*

%files data -f %name.lang
%config %_sysconfdir/pam.d/gdm-autologin
%config %_sysconfdir/pam.d/gdm-password
%config %_sysconfdir/pam.d/gdm-launch-environment
%config %_sysconfdir/pam.d/gdm-smartcard
%config %_sysconfdir/pam.d/gdm-fingerprint
%_udevrulesdir/61-%name.rules
%config %_sysconfdir/dbus-1/system.d/%name.conf
%config %_datadir/glib-2.0/schemas/org.gnome.login-screen.gschema.xml
%config(noreplace) %_sysconfdir/X11/%name
%dir %_sysconfdir/X11/sessions
%config %_controldir/gdm_xdmcp
%_sysconfdir/X11/wms-methods.d/%name
%dir %_datadir/%name
%_datadir/%name/locale.alias
%_datadir/%name/gdb-cmd
%_datadir/%name/%name.schemas
%dir %_datadir/%name/greeter
%dir %_datadir/%name/greeter/applications
%_datadir/%name/greeter-dconf-defaults
%_datadir/gnome-session/sessions/gnome-login.session
%_datadir/dconf/profile/%name
%attr(1770, gdm, gdm) %dir %_localstatedir/lib/gdm
%attr(1750, gdm, gdm) %dir %_localstatedir/lib/gdm/.config
%attr(1750, gdm, gdm) %dir %_localstatedir/lib/gdm/.config/pulse
%attr(0600, gdm, gdm) %_localstatedir/lib/gdm/.config/pulse/default.pa
%_datadir/gdm/greeter/applications/mime-dummy-handler.desktop
%_datadir/gdm/greeter/applications/mimeapps.list
%dir %_datadir/%name/greeter/autostart
%exclude %_datadir/gdm/greeter/autostart/orca-autostart.desktop

%files help -f %name-help.lang

%files libs
%_libdir/libgdm.so.*

%files libs-devel
%_includedir/gdm/
%_libdir/libgdm.so
%_pkgconfigdir/%name.pc
%_pkgconfigdir/%name-pam-extensions.pc

%files libs-gir
%_typelibdir/Gdm-%api_ver.typelib

%files libs-gir-devel
%_girdir/Gdm-%api_ver.gir

%exclude %_sysconfdir/pam.d/gdm-pin

%changelog
