# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: geany
Version: 1.38
Release: alt1

Summary: A fast and lightweight IDE using GTK2
License: GPLv2
Group: Development/Tools
Url: http://geany.org

Source: %name-%version.tar.bz2
Patch: geany-1.35-defaults.patch

Requires: libvte
Requires: %name-data = %version
BuildPreReq: desktop-file-utils

%add_findreq_skiplist %_datadir/%name/templates/files/*

# Automatically added by buildreq on Sat Nov 07 2020
# optimized out: at-spi2-atk fontconfig glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libX11-devel libat-spi2-core libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libharfbuzz-devel libpango-devel libstdc++-devel libwayland-client libwayland-client-devel libwayland-cursor libwayland-egl perl perl-Encode perl-XML-Parser perl-parent pkg-config python-module-lxml python-modules python-modules-compiler python-modules-encodings python2-base sh4 shared-mime-info wayland-devel xorg-proto-devel
BuildRequires: gcc-c++ git-core intltool libgtk+3-devel libgtk4-devel python3-module-docutils time rpm-build-python3

%description
Geany is a small and lightweight integrated development environment.
It was developed to provide a small and fast IDE, which has only a few
dependencies from other packages. Another goal was to be as
independent as possible from a special Desktop Environment like KDE or
GNOME. So it is using only the GTK2 toolkit and therefore you need
only the GTK2 runtime libraries to run Geany.

%package data
Summary: Data files for Geany IDE
Group: Development/Tools
BuildArch: noarch
Requires: %name = %version

%description data
Architecture-independent data files for Geany IDE.

%package devel
Summary: Header files for building Geany plug-ins
Group: Development/C
Requires: %name = %version

%description devel
This package contains the header files and pkg-config file needed for
building Geany plug-ins. You do not need to install this package to
use Geany.

%prep
%setup
%patch -p1

# hack out space in file name
sed -i '/"untitled"/,/^$/s/\([^a-z]\) \([^a-z]\)/\1_\2/g' po/ru.po

# hack in python version
sed -i 's/env python$/env python3/' data/templates/files/main.py

# Add some hello world examples
# C++
cat > data/templates/files/hello_world.cpp <<@@@
{fileheader}

#include <iostream>

int main(int argc, char **argv)
{
	std::cout << "Hello world!\n";
	return 0;
}
@@@

# Basic
cat > data/templates/files/hello_world.bas <<@@@
{fileheader}
PRINT "Hello World!"
SLEEP
@@@

# Pascal
cat > data/templates/files/hello_world.pas <<@@@
{fileheader}

program Hello;
begin
  writeln ('Hello, world!');
end.
@@@

%build
NOCONFIGURE=1 ./autogen.sh

%configure --docdir=%_defaultdocdir/%name-%version \
            --enable-html-docs \
            --with-python-command=python3

%make_build --silent --no-print-directory

%install
%makeinstall_std --silent --no-print-directory
%find_lang %name
bzip2 %buildroot%_defaultdocdir/%name-%version/ChangeLog

%check
%make check

%files
%_bindir/%name
%_libdir/%name/
%_libdir/*.so.*

%files -f %name.lang data
%_datadir/%name/
%_man1dir/%name.1.*
%_desktopdir/%name.desktop
%_iconsdir/*/*/*/*
%_defaultdocdir/%name-%version/

%files devel
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_libdir/*.so

%changelog
