%def_disable snapshot
%set_verify_elf_method unresolved=relaxed
%define xdg_name org.gnome.gedit
%define _libexecdir %_prefix/libexec

%define ver_major 40
%define api_ver 3.0
%def_enable plugins
%def_enable introspection
%def_enable vala
%def_enable gtk_doc

Name: gedit
Version: %ver_major.1
Release: alt1.1

Summary: gEdit is a small but powerful text editor for GNOME
License: GPL-2.0
Group: Editors
Url: http://www.gedit.org

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%endif

%{?_enable_python:%py3_provides gedit}
%define  gedit_pluginsdir %_libdir/gedit/plugins
%add_python3_path %gedit_pluginsdir

%define pkglibdir %_libdir/%name
%define pkgdatadir %_datadir/%name
%set_typelibdir %pkglibdir
%set_girdir %pkgdatadir

%define glib_ver 2.44.0
%define gtk_ver 3.22.0
%define tepl_ver 5.99.0
%define gtksourceview_ver 4.0.3
%define peas_ver 1.14.1
%define gspell_ver 1.0.0
%define soup_ver 2.60.0

Requires: %name-data = %version-%release
Requires: %name-gir = %version-%release
Requires: libpeas-python3-loader
Requires: dconf gnome-icon-theme gvfs zenity

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson yelp-tools libappstream-glib-devel
BuildRequires: desktop-file-utils >= 0.22
BuildRequires: gtk-doc >= 1.0
BuildRequires: iso-codes-devel >= 0.35
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(tepl-6) >= %tepl_ver
BuildRequires: libpeas-devel >= %peas_ver
BuildRequires: libgtksourceview4-devel >= %gtksourceview_ver
BuildRequires: libgspell-devel >= %gspell_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libattr-devel libxml2-devel gsettings-desktop-schemas-devel
%{?_enable_vala:BuildRequires: vala-tools}
%if_enabled plugins
BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-devel python3-module-pygobject3-devel
%endif
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.10.2 libgtk+3-gir-devel libgtksourceview4-gir-devel}

%description
gEdit is the official text editor of the GNOME desktop environment.

While aiming at simplicity and ease of use, gedit is a powerful general
purpose text editor which features full support for UTF-8, configurable
highlighting for various languages and many other features making it a
great editor for advanced tasks.

%package data
Summary: Arch independent files for gEdit
Group: Editors
BuildArch: noarch

%description data
This package provides noarch data needed for gEdit to work.

%package devel
Group: Development/C
Summary: Libraries needed to develop plugins for gedit
Requires: %name = %version-%release
Requires: libgtksourceview-devel

%description devel
Libraries needed to develop plugins for gedit.

%package gir
Summary: GObject introspection data for the Gedit
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Gedit

%package gir-devel
Summary: GObject introspection devel data for the Gedit
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Gedit

%package devel-doc
Group: Development/C
Summary: Development documentation for gedit
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
This package contains documentation needed to develop plugins for gedit.


%prep
%setup

%build
%meson -Dbuildtype=plain \
    %{?_disable_plugins:-Dplugins=false} \
    %{?_disable_introspection:-Dintrospection=false} \
    %{?_disable_vala:-Dvapi=flalse} \
    %{?_enable_gtk_doc:-Dgtk_doc=true}
%meson_build

%install
%meson_install

# additional mime types
desktop-file-install --dir %buildroot%_desktopdir \
	--add-mime-type=text/css \
	--add-mime-type=text/csv \
	--add-mime-type=text/english \
	--add-mime-type=text/plain \
	--add-mime-type=text/tab-separated-values \
	--add-mime-type=text/x-adasrc \
	--add-mime-type=text/x-bibtex \
	--add-mime-type=text/x-c++ \
	--add-mime-type=text/x-chdr \
	--add-mime-type=text/x-c++hdr \
	--add-mime-type=text/x-csharp \
	--add-mime-type=text/x-csrc \
	--add-mime-type=text/x-c++src \
	--add-mime-type=text/x-dsrc \
	--add-mime-type=text/x-fortran \
	--add-mime-type=text/x-gle \
	--add-mime-type=text/x-java \
	--add-mime-type=text/x-javascript \
	--add-mime-type=text/x-log \
	--add-mime-type=text/x-makefile \
	--add-mime-type=text/x-objcsrc \
	--add-mime-type=text/x-pascal \
	--add-mime-type=text/x-patch \
	--add-mime-type=text/x-perl \
	--add-mime-type=text/x-php \
	--add-mime-type=text/x-python \
	--add-mime-type=text/x-sql \
	--add-mime-type=text/x-sh \
	--add-mime-type=text/x-tcl \
	--add-mime-type=text/x-tex \
	%buildroot%_desktopdir/%xdg_name.desktop

%find_lang --with-gnome %name

%files
%_bindir/*
%dir %pkglibdir
%pkglibdir/lib%{name}*.so
%dir %gedit_pluginsdir
%gedit_pluginsdir/*
%{?_enable_plugins:%python3_sitelibdir_noarch/gi/overrides/Gedit.py*}
%{?_enable_plugins:%python3_sitelibdir_noarch/gi/overrides/__pycache__/}

%files data -f %name.lang
%pkgdatadir/
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/org.gnome.gedit.service
%_mandir/man?/*
%config %_datadir/glib-2.0/schemas/*
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README* NEWS

%exclude %pkgdatadir/gir-1.0/

%files devel
%_includedir/*
%_pkgconfigdir/*
%_vapidir/%name.deps
%_vapidir/%name.vapi

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%name
%endif

%if_enabled introspection
%files gir
%pkglibdir/girepository-1.0/Gedit-%api_ver.typelib
%files gir-devel
%pkgdatadir/gir-1.0/Gedit-%api_ver.gir
%endif

%changelog
