%define        gemname mysql2

Name:          gem-mysql2
Version:       0.5.4.1
Release:       alt1
Summary:       A modern, simple and very fast Mysql library for Ruby - binding to libmysql
License:       MIT
Group:         Development/Ruby
Url:           https://github.com/brianmario/mysql2
Vcs:           https://github.com/brianmario/mysql2.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libmysqlclient-devel

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency rake-compiler >= 1.1.2,rake-compiler < 2
%ruby_use_gem_dependency rake-compiler-dock >= 1.1.0,rake-compiler-dock < 2
%ruby_use_gem_dependency rubocop >= 1.15.0,rubocop < 2
Obsoletes:     ruby-mysql2 < %EVR
Provides:      ruby-mysql2 = %EVR
Provides:      gem(mysql2) = 0.5.4.1

%ruby_use_gem_version mysql2:0.5.4.1

%description
The Mysql2 gem is meant to serve the extremely common use-case of connecting,
querying and iterating on results. Some database libraries out there serve as
direct 1:1 mappings of the already complex C APIs available. This one is
not.

It also forces the use of UTF-8 [or binary] for the connection [and all strings
in 1.9, unless Encoding.default_internal is set then it will convert from UTF-8
to that encoding] and uses encoding-aware MySQL API calls where it can.


%package       -n gem-mysql2-doc
Version:       0.5.4.1
Release:       alt1
Summary:       A modern, simple and very fast Mysql library for Ruby - binding to libmysql documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета mysql2
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(mysql2) = 0.5.4.1

%description   -n gem-mysql2-doc
A modern, simple and very fast Mysql library for Ruby - binding to libmysql
documentation files.

The Mysql2 gem is meant to serve the extremely common use-case of connecting,
querying and iterating on results. Some database libraries out there serve as
direct 1:1 mappings of the already complex C APIs available. This one is
not.

It also forces the use of UTF-8 [or binary] for the connection [and all strings
in 1.9, unless Encoding.default_internal is set then it will convert from UTF-8
to that encoding] and uses encoding-aware MySQL API calls where it can.

%description   -n gem-mysql2-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета mysql2.


%package       -n gem-mysql2-devel
Version:       0.5.4.1
Release:       alt1
Summary:       A modern, simple and very fast Mysql library for Ruby - binding to libmysql development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета mysql2
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(mysql2) = 0.5.4.1
Requires:      libmysqlclient-devel

%description   -n gem-mysql2-devel
A modern, simple and very fast Mysql library for Ruby - binding to libmysql
development package.

The Mysql2 gem is meant to serve the extremely common use-case of connecting,
querying and iterating on results. Some database libraries out there serve as
direct 1:1 mappings of the already complex C APIs available. This one is
not.

It also forces the use of UTF-8 [or binary] for the connection [and all strings
in 1.9, unless Encoding.default_internal is set then it will convert from UTF-8
to that encoding] and uses encoding-aware MySQL API calls where it can.

%description   -n gem-mysql2-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета mysql2.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n gem-mysql2-doc
%doc README.md
%ruby_gemdocdir

%files         -n gem-mysql2-devel
%doc README.md
%ruby_includedir/*


%changelog
