%define        gemname rmagick

Name:          gem-rmagick
Version:       4.3.0
Release:       alt1
Summary:       ImageMagick for Ruby
License:       MIT
Group:         Development/Ruby
Url:           https://rmagick.github.io/
Vcs:           https://github.com/rmagick/rmagick.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libImageMagick-devel >= 6.6.9.6-alt1
%if_with check
BuildRequires: gem(pry) >= 0.13.1
BuildRequires: gem(rake-compiler) >= 1.0
BuildRequires: gem(rspec) >= 3.8
BuildRequires: gem(rspec_junit_formatter) >= 0.4.1
BuildRequires: gem(rubocop) >= 0.81.0
BuildRequires: gem(rubocop-rspec) >= 1.38.1
BuildRequires: gem(rubocop-performance) >= 1.5.2
BuildRequires: gem(simplecov) >= 0.16.1
BuildRequires: gem(yard) >= 0.9.24
BuildConflicts: gem(pry) >= 1
BuildConflicts: gem(rake-compiler) >= 2
BuildConflicts: gem(rspec) >= 4
BuildConflicts: gem(rspec_junit_formatter) >= 1
BuildConflicts: gem(rubocop) >= 2
BuildConflicts: gem(rubocop-rspec) >= 3
BuildConflicts: gem(rubocop-performance) >= 2
BuildConflicts: gem(simplecov) >= 1
BuildConflicts: gem(yard) >= 0.10
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency rubocop >= 1.15.0,rubocop < 2
%ruby_use_gem_dependency simplecov >= 0.17,simplecov < 1
%ruby_use_gem_dependency pry >= 0.13.1,pry < 1
%ruby_use_gem_dependency rubocop-rspec >= 2.4.0,rubocop-rspec < 3
%ruby_use_gem_dependency rubocop-performance >= 1.11.3,rubocop-performance < 2
%ruby_use_gem_dependency rspec_junit_formatter >= 0.5.1,rspec_junit_formatter < 1
Obsoletes:     ruby-rmagick < %EVR
Provides:      ruby-rmagick = %EVR
Provides:      gem(rmagick) = 4.3.0


%description
RMagick is an interface between the Ruby programming language and the
ImageMagick image processing library.


%package       -n gem-rmagick-doc
Version:       4.3.0
Release:       alt1
Summary:       ImageMagick for Ruby documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета rmagick
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(rmagick) = 4.3.0

%description   -n gem-rmagick-doc
ImageMagick for Ruby documentation files.

RMagick is an interface between the Ruby programming language and the
ImageMagick image processing library.

%description   -n gem-rmagick-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета rmagick.


%package       -n gem-rmagick-devel
Version:       4.3.0
Release:       alt1
Summary:       ImageMagick for Ruby development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета rmagick
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(rmagick) = 4.3.0
Requires:      gem(pry) >= 0.13.1
Requires:      gem(rake-compiler) >= 1.0
Requires:      gem(rspec) >= 3.8
Requires:      gem(rspec_junit_formatter) >= 0.4.1
Requires:      gem(rubocop) >= 0.81.0
Requires:      gem(rubocop-rspec) >= 1.38.1
Requires:      gem(rubocop-performance) >= 1.5.2
Requires:      gem(simplecov) >= 0.16.1
Requires:      gem(yard) >= 0.9.24
Requires:      libImageMagick-devel >= 6.6.9.6-alt1
Conflicts:     gem(pry) >= 1
Conflicts:     gem(rake-compiler) >= 2
Conflicts:     gem(rspec) >= 4
Conflicts:     gem(rspec_junit_formatter) >= 1
Conflicts:     gem(rubocop) >= 2
Conflicts:     gem(rubocop-rspec) >= 3
Conflicts:     gem(rubocop-performance) >= 2
Conflicts:     gem(simplecov) >= 1
Conflicts:     gem(yard) >= 0.10

%description   -n gem-rmagick-devel
ImageMagick for Ruby development package.

RMagick is an interface between the Ruby programming language and the
ImageMagick image processing library.

%description   -n gem-rmagick-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета rmagick.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n gem-rmagick-doc
%doc README.md
%ruby_gemdocdir

%files         -n gem-rmagick-devel
%doc README.md
%ruby_includedir/*


%changelog
