%define        gemname unicorn

Name:          gem-unicorn
Version:       6.1.0
Release:       alt1.1
Summary:       Unicorn: Rack HTTP server for fast clients and Unix
License:       GPL-2.0+ or Ruby-1.8
Group:         System/Servers
Url:           https://unicorn.bogomips.org/
Vcs:           https://bogomips.org/unicorn.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: ragel6
BuildRequires: gem(rack) >= 0
BuildRequires: gem(kgio) >= 2.6 gem(kgio) < 3
BuildRequires: gem(raindrops) >= 0.7 gem(raindrops) < 1
BuildRequires: gem(test-unit) >= 3.0 gem(test-unit) < 4

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Requires:      gem(kgio) >= 2.6 gem(kgio) < 3
Requires:      gem(raindrops) >= 0.7 gem(raindrops) < 1
Provides:      gem(unicorn) = 6.1.0


%description
Unicorn is an HTTP server for Rack applications designed to only serve fast
clients on low-latency, high-bandwidth connections and take advantage of
features in Unix/Unix-like kernels. Slow clients should only be served by
placing a reverse proxy capable of fully buffering both the the request and
response in between Unicorn and slow clients.


%package       -n unicorn
Version:       6.1.0
Release:       alt1.1
Summary:       Unicorn: Rack HTTP server for fast clients and Unix executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета unicorn
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(unicorn) = 6.1.0
Conflicts:     golang-tools

%description   -n unicorn
Unicorn: Rack HTTP server for fast clients and Unix executable(s).

Unicorn is an HTTP server for Rack applications designed to only serve fast
clients on low-latency, high-bandwidth connections and take advantage of
features in Unix/Unix-like kernels. Slow clients should only be served by
placing a reverse proxy capable of fully buffering both the the request and
response in between Unicorn and slow clients.

%description   -n unicorn -l ru_RU.UTF-8
Исполнямка для самоцвета unicorn.


%package       -n gem-unicorn-doc
Version:       6.1.0
Release:       alt1.1
Summary:       Unicorn: Rack HTTP server for fast clients and Unix documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета unicorn
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(unicorn) = 6.1.0

%description   -n gem-unicorn-doc
Unicorn: Rack HTTP server for fast clients and Unix documentation
files.

Unicorn is an HTTP server for Rack applications designed to only serve fast
clients on low-latency, high-bandwidth connections and take advantage of
features in Unix/Unix-like kernels. Slow clients should only be served by
placing a reverse proxy capable of fully buffering both the the request and
response in between Unicorn and slow clients.

%description   -n gem-unicorn-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета unicorn.


%package       -n gem-unicorn-devel
Version:       6.1.0
Release:       alt1.1
Summary:       Unicorn: Rack HTTP server for fast clients and Unix development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета unicorn
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(unicorn) = 6.1.0
Requires:      gem(rack) >= 0
Requires:      gem(test-unit) >= 3.0 gem(test-unit) < 4
Requires:      ragel6

%description   -n gem-unicorn-devel
Unicorn: Rack HTTP server for fast clients and Unix development
package.

Unicorn is an HTTP server for Rack applications designed to only serve fast
clients on low-latency, high-bandwidth connections and take advantage of
features in Unix/Unix-like kernels. Slow clients should only be served by
placing a reverse proxy capable of fully buffering both the the request and
response in between Unicorn and slow clients.

%description   -n gem-unicorn-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета unicorn.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n unicorn
%doc README
%_bindir/unicorn
%_bindir/unicorn_rails

%files         -n gem-unicorn-doc
%doc README
%ruby_gemdocdir

%files         -n gem-unicorn-devel
%doc README
%ruby_includedir/*


%changelog
