%def_without qt4

Name: gimagereader
Version: 3.4.1
Release: alt4

Summary: A graphical GTK frontend to tesseract-ocr

License: GPLv3+
Group: Office
Url: https://github.com/manisandro/gImageReader

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/manisandro/gImageReader/archive/v%version.tar.gz
Source: %name-%version.tar

Source1: gimagereader-translations-ru.po
Source2: manual-ru.html.in

Patch1: gimagereader-fix-rescan-altbug-48017.patch
Patch2: gimagereader-fix-gtk-rescan-altbug-48017.patch


BuildRequires(pre): rpm-macros-cmake rpm-build-python3

BuildRequires: cmake intltool gcc-c++
BuildRequires: libgomp-devel libjson-glib-devel libsane-devel libxml++3-devel libleptonica-devel libpcre-devel libexpat-devel libdrm-devel libpodofo-devel libdjvu-devel libzip-devel libuuid-devel tesseract-devel

BuildRequires: python3 python3-module-pygobject3 libgtk+3-gir gobject-introspection-devel

# something wrong
# Package 'xrandr', required by 'GDK', not found
#BuildPreReq: libdrm-devel libXdmcp-devel libXdamage-devel libXxf86vm-devel libXinerama-devel libXi-devel libXrandr-devel libXcursor-devel libXcomposite-devel wayland-protocols libxkbcommon-devel

# need pkgconfig from 3.04 and above
BuildRequires: tesseract-devel >= 3.04.01

# gtk
BuildRequires: libgtksourceviewmm3-devel libpoppler-glib-devel
BuildRequires: libgtkspellmm3-devel >= 3.0.5

%if_with qt4
BuildRequires: libqt4-devel libqtspell-qt4-devel libpoppler-qt4-devel
%endif

# qt5
BuildRequires: libqtspell-qt5-devel libpoppler-qt5-devel qt5-base-devel libquazip-qt5-devel libquazip-qt5-devel qt5-imageformats

# for compatibility
Requires: %name-gtk

%description
gImageReader is a simple Gtk front-end to tesseract. Features include:
 - Automatic page layout detection
 - User can manually define and adjust recognition regions
 - Import images from disk, scanning devices, clipboard and screenshots
 - Supports multipage PDF documents
 - Recognized text displayed directly next to the image
 - Editing of output text, including search/replace and removing line breaks
 - Spellchecking for output text (if corresponding dictionary installed)

%package gtk
Group: Office
Summary: A Gtk+ front-end to tesseract-ocr
Requires: %name-common = %version-%release
Obsoletes: %name < 2.94

%description gtk
gImageReader is a simple front-end to tesseract. Features include:
 - Automatic page layout detection
 - User can manually define and adjust recognition regions
 - Import images from disk, scanning devices, clipboard and screenshots
 - Supports multipage PDF documents
 - Recognized text displayed directly next to the image
 - Editing of output text, including search/replace and removing line breaks
 - Spellchecking for output text (if corresponding dictionary installed)
This package contains the Gtk+ front-end.

%package qt5
Group: Office
Summary: A Qt 5 front-end to tesseract-ocr
Requires: %name-common = %version-%release
%if_without qt4
Provides: gimagereader-qt4 = %EVR
Obsoletes: gimagereader-qt4 < %EVR
%endif

%description qt5
gImageReader is a simple front-end to tesseract. Features include:
 - Automatic page layout detection
 - User can manually define and adjust recognition regions
 - Import images from disk, scanning devices, clipboard and screenshots
 - Supports multipage PDF documents
 - Recognized text displayed directly next to the image
 - Editing of output text, including search/replace and removing line breaks
 - Spellchecking for output text (if corresponding dictionary installed)
This package contains the Qt front-end.

%if_with qt4
%package qt4
Group: Office
Summary: A Qt4 front-end to tesseract-ocr
Requires: %name-common = %version-%release

%description qt4
gImageReader is a simple front-end to tesseract. Features include:
 - Automatic page layout detection
 - User can manually define and adjust recognition regions
 - Import images from disk, scanning devices, clipboard and screenshots
 - Supports multipage PDF documents
 - Recognized text displayed directly next to the image
 - Editing of output text, including search/replace and removing line breaks
 - Spellchecking for output text (if corresponding dictionary installed)
This package contains the Qt front-end.
%endif

%package common
Group: Office
Summary: Common files for %name
BuildArch: noarch
Conflicts: %name < 3.1.2
Requires: iso-codes


%description common
Common files for %name.

%prep
%setup
%patch1 -p1
%patch2 -p1

# remove with new version
# https://redmine.basealt.space/issues/2497
cp -fv %SOURCE1 po/ru.po
%if 0
cp -fv %SOURCE2 data/
%endif

cat <<EOF >>data/gimagereader.desktop.in
Comment=Scan pages and optical text recognize
Comment[ru]=Сканирование страниц и распознавание текста
EOF

# https://bugzilla.altlinux.org/47822
subst 's|text/html;||' data/gimagereader.desktop.in

subst "s|/usr/bin/python$|%__python3|" gtk/data/uigen.py

%build
%define _cmake__builddir build-gtk
%cmake -DINTERFACE_TYPE=gtk -DENABLE_VERSIONCHECK=0 -DMANUAL_DIR="%_docdir/%name-common"
%cmake_build

%if_with qt4
%define _cmake__builddir build-qt4
%cmake -DINTERFACE_TYPE=qt4 -DENABLE_VERSIONCHECK=0 -DMANUAL_DIR="%_docdir/%name-common"
%cmake_build
%endif

%define _cmake__builddir build-qt5
%cmake -DINTERFACE_TYPE=qt5 -DENABLE_VERSIONCHECK=0 -DMANUAL_DIR="%_docdir/%name-common"
%cmake_build

%install
%define _cmake__builddir build-gtk
%cmake_install

%if_with qt4
%define _cmake__builddir build-qt4
%cmake_install
%endif

%define _cmake__builddir build-qt5
%cmake_install

%find_lang %name
rm -rfv %buildroot%_datadir/locale/{sr_Cyrl,sr_Latn}/

# make link to old base command
ln -s %name-gtk %buildroot%_bindir/%name


%files common -f %name.lang
%doc COPYING
%doc AUTHORS README.md
%_iconsdir/hicolor/48x48/apps/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%_iconsdir/hicolor/256x256/apps/%name.png
%doc %_docdir/%name-common/manual*.html

%files gtk
%_bindir/%name-gtk
%_datadir/metainfo/%name-gtk.appdata.xml
%_desktopdir/%name-gtk.desktop
%_datadir/glib-2.0/schemas/org.gnome.%name.gschema.xml

%if_with qt4
%files qt4
%_bindir/%name-qt4
#_datadir/appdata/%name-qt4.appdata.xml
%_desktopdir/%name-qt4.desktop
%endif

%files qt5
%_bindir/%name-qt5
%_datadir/metainfo/%name-qt5.appdata.xml
%_desktopdir/%name-qt5.desktop

%files
%_bindir/%name

%changelog
