Name: git-cola
Version: 3.9
Release: alt1

Summary: A highly caffeinated git gui
License: GPL-2.0-or-later
Group: Development/Tools

Url: https://git-cola.github.io
# https://github.com/git-cola/git-cola.git
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx-devel
#BuildRequires: rpm-build-gir tcl
BuildRequires: asciidoc
# hasher tests:
Requires: python3-module-pyinotify python3-module-PyQt5 git-core

AutoReq: no
AutoProv: yes,nopython
# skip internal module reqs
%add_python3_req_skip cola cola.i18n cola.models cola.widgets

%description
A sweet, carbonated git gui known for its sugary flavour
and caffeine-inspired features.

%prep
%setup

# fix python shebangs
sed -i 's|/usr/bin/env python|%__python3|' $(find ./ -name '*.py')
sed -i 's|/usr/bin/env python|%__python3|' bin/git-cola bin/git-cola-sequence-editor bin/git-dag contrib/travis-build
sed -i 's|python|%__python3|' setup.cfg

%prepare_sphinx3 share/doc/%name

%build
%python3_build_debug

%install
%python3_install
%find_lang %name
# because executable script is not executable
chmod +x %buildroot%python3_sitelibdir/cola/widgets/spellcheck.py
chmod +x %buildroot%_datadir/git-cola/lib/cola/widgets/spellcheck.py

%files -f %name.lang
%doc COPYING COPYRIGHT README.md
%_bindir/*
%_desktopdir/*.desktop
%_datadir/git-cola
%_datadir/metainfo/git-cola.appdata.xml
%_datadir/metainfo/git-dag.appdata.xml
%_docdir/git-cola
#_man1dir/*
%python3_sitelibdir/*

%changelog
